/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.util.WebUtil;
import org.springframework.extensions.webscripts.URLHelper;

public class DefaultURLHelper
implements Serializable,
URLHelper {
    private static final long serialVersionUID = -966485798540601444L;
    private final String context;
    private final String pageContext;
    private final String uri;
    private final String queryString;
    private final Map<String, String> args;
    private final Map<String, String> templateArgs = new HashMap<String, String>(4, 1.0f);

    public DefaultURLHelper(RequestContext context) {
        this.context = context.getContextPath();
        this.uri = context.getUri();
        String uriNoContext = context.getUri().substring(this.context.length());
        StringTokenizer t = new StringTokenizer(uriNoContext, "/");
        this.pageContext = t.hasMoreTokens() ? this.context + "/" + t.nextToken() : this.context;
        this.queryString = WebUtil.getQueryStringForMap(context.getParameters());
        this.args = Collections.unmodifiableMap((HashMap)((HashMap)context.getParameters()).clone());
    }

    public DefaultURLHelper(RequestContext context, Map<String, String> templateArgs) {
        this(context);
        if (templateArgs != null) {
            this.templateArgs.putAll(templateArgs);
        }
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getServletContext() {
        return this.pageContext;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getUrl() {
        return this.uri + (String)(this.queryString.length() != 0 ? "?" + this.queryString : "");
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Map<String, String> getArgs() {
        return this.args;
    }

    @Override
    public Map<String, String> getTemplateArgs() {
        return Collections.unmodifiableMap(this.templateArgs);
    }
}

