/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Map;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.LocalWebScriptContext;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptRequestURLImpl;

public class LocalWebScriptRequest
extends WebScriptRequestURLImpl {
    private final Map<String, Serializable> parameters;
    private final ServerProperties serverProperties;
    private final LocalWebScriptContext context;
    private final String[] parameterNames;

    public LocalWebScriptRequest(Runtime runtime, String scriptUrl, Match match, Map<String, Serializable> parameters, ServerProperties serverProps, LocalWebScriptContext context) {
        super(runtime, LocalWebScriptRequest.splitURL((String)context.getRequestContext().getContextPath(), (String)scriptUrl), match);
        parameters.putAll(this.queryArgs);
        this.parameters = parameters;
        this.serverProperties = serverProps;
        this.context = context;
        this.parameterNames = this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public String getParameter(String name) {
        return (String)((Object)this.parameters.get(name));
    }

    public String[] getParameterValues(String name) {
        String[] values = new String[]{(String)((Object)this.parameters.get(name))};
        return values;
    }

    public String getAgent() {
        return null;
    }

    public String getServerPath() {
        return this.getServerScheme() + "://" + this.getServerName() + ":" + this.getServerPort();
    }

    public String[] getHeaderNames() {
        return new String[0];
    }

    public String getHeader(String name) {
        return null;
    }

    public String[] getHeaderValues(String name) {
        return null;
    }

    public Content getContent() {
        return null;
    }

    private String getServerScheme() {
        HttpServletRequest request = ServletUtil.getRequest();
        String scheme = null;
        if (this.serverProperties != null) {
            scheme = this.serverProperties.getScheme();
        }
        if (scheme == null) {
            scheme = request.getScheme();
        }
        return scheme;
    }

    private String getServerName() {
        HttpServletRequest request = ServletUtil.getRequest();
        String name = null;
        if (this.serverProperties != null) {
            name = this.serverProperties.getHostName();
        }
        if (name == null) {
            name = request.getServerName();
        }
        return name;
    }

    private int getServerPort() {
        HttpServletRequest request = ServletUtil.getRequest();
        Integer port = null;
        if (this.serverProperties != null) {
            port = this.serverProperties.getPort();
        }
        if (port == null) {
            port = request.getServerPort();
        }
        return port;
    }
}

