/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.webscripts.ScriptHelper;
import org.springframework.extensions.webscripts.ScriptModelObject;
import org.springframework.extensions.webscripts.ScriptableMap;

public abstract class ScriptBase
implements Serializable {
    protected final RequestContext context;
    protected ScriptableMap<String, Serializable> properties;

    public ScriptBase(RequestContext context) {
        this.context = context;
    }

    public ScriptBase() {
        this.context = null;
    }

    public final RequestContext getRequestContext() {
        return this.context;
    }

    protected ModelObjectService getObjectService() {
        return this.context.getObjectService();
    }

    public final ScriptModelObject getObject(String objectTypeId, String objectId) {
        return ScriptHelper.getObject(this.getRequestContext(), objectTypeId, objectId);
    }

    public ScriptableMap<String, Serializable> getProperties() {
        if (this.properties == null) {
            this.properties = this.buildProperties();
        }
        return this.properties;
    }

    public final WebFrameworkConfigElement getConfig() {
        return FrameworkBean.getConfig();
    }

    public String toString() {
        if (this.getProperties() != null) {
            return this.getProperties().toString();
        }
        return this.context.toString();
    }

    protected abstract ScriptableMap<String, Serializable> buildProperties();
}

