/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.ext.dom.NodeModel;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.resource.ResourceContent;
import org.springframework.extensions.surf.resource.ResourceJSONContent;
import org.springframework.extensions.surf.resource.ResourceXMLContent;
import org.springframework.extensions.webscripts.ScriptBase;
import org.springframework.extensions.webscripts.ScriptResource;
import org.springframework.extensions.webscripts.ScriptableMap;
import org.xml.sax.InputSource;

public final class ScriptResourceContent
extends ScriptBase {
    private static Log logger = LogFactory.getLog(ScriptResourceContent.class);
    private final ResourceContent resourceContent;
    private final ScriptResource resource;

    public ScriptResourceContent(RequestContext context, ScriptResource resource, ResourceContent resourceContent) {
        super(context);
        this.resourceContent = resourceContent;
        this.resource = resource;
    }

    @Override
    protected ScriptableMap<String, Serializable> buildProperties() {
        return null;
    }

    public ScriptResource getResource() {
        return this.resource;
    }

    public String getString() {
        String result = null;
        try {
            result = this.resourceContent.getStringContent();
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
        }
        return result;
    }

    public String getXml() {
        String xml = null;
        if (this.resourceContent instanceof ResourceXMLContent) {
            try {
                xml = ((ResourceXMLContent)this.resourceContent).getXml();
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
            }
        }
        return xml;
    }

    public NodeModel getXmlNodeModel() {
        NodeModel nodeModel = null;
        try {
            nodeModel = NodeModel.parse((InputSource)new InputSource(new StringReader(this.getXml())));
        }
        catch (Throwable err) {
            logger.error((Object)err);
        }
        return nodeModel;
    }

    public String getJson() {
        String jsonString = null;
        if (this.resourceContent instanceof ResourceJSONContent) {
            try {
                jsonString = ((ResourceJSONContent)this.resourceContent).getJSONString();
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
            }
        }
        return jsonString;
    }
}

