/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.util.LinkedHashSet;
import java.util.Set;

public class DojoDependencies {
    private Set<String> javaScriptDeps = new LinkedHashSet<String>();
    private Set<String> textDeps = new LinkedHashSet<String>();
    private Set<CssDependency> cssDeps = new LinkedHashSet<CssDependency>();
    private Set<I18nDependency> i18nDeps = new LinkedHashSet<I18nDependency>();
    private Set<String> nonAmdDependencies = new LinkedHashSet<String>();

    public void addJavaScriptDep(String javaScriptDep) {
        this.javaScriptDeps.add(javaScriptDep);
    }

    public void addTextDep(String textDep) {
        this.textDeps.add(textDep);
    }

    public void addCssDep(String path, String mediaType) {
        this.cssDeps.add(new CssDependency(path, mediaType));
    }

    public void addI18nDep(String path, String scope) {
        this.i18nDeps.add(new I18nDependency(path, scope));
    }

    public void addNonAmdDep(String path) {
        this.nonAmdDependencies.add(path);
    }

    public Set<String> getJavaScriptDeps() {
        return this.javaScriptDeps;
    }

    public Set<String> getTextDeps() {
        return this.textDeps;
    }

    public Set<CssDependency> getCssDeps() {
        return this.cssDeps;
    }

    public Set<I18nDependency> getI18nDeps() {
        return this.i18nDeps;
    }

    public Set<String> getNonAmdDependencies() {
        return this.nonAmdDependencies;
    }

    public String toString() {
        return "JavaScript Deps=" + this.javaScriptDeps.toString() + ", CSS Deps=" + this.cssDeps.toString() + ", Text Deps=" + this.textDeps.toString();
    }

    public class CssDependency {
        private String path;
        private String mediaType;

        public CssDependency(String path, String mediaType) {
            this.path = path;
            this.mediaType = mediaType;
        }

        public String getPath() {
            return this.path;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public String toString() {
            return "Path=" + this.path + ", media type=" + this.mediaType;
        }
    }

    public class I18nDependency {
        private String path;
        private String scope;

        public I18nDependency(String path, String scope) {
            this.path = path;
            this.scope = scope;
        }

        public String getPath() {
            return this.path;
        }

        public String getScope() {
            return this.scope;
        }

        public String toString() {
            return "Path=" + this.path + ", scope=" + this.scope;
        }
    }
}

