/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class CacheItem<K>
implements Serializable {
    private static final long serialVersionUID = 4526472295622776147L;
    private String key;
    K object;
    private long timeout;
    private long stamp;
    long lastChecked;

    public CacheItem(String key, K obj, long timeout) {
        this.timeout = timeout;
        this.key = key;
        this.object = obj;
        this.lastChecked = this.stamp = System.currentTimeMillis();
    }

    public boolean isExpired() {
        if (this.timeout == -1L) {
            return false;
        }
        return this.timeout < System.currentTimeMillis() - this.stamp;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(new Long(this.timeout));
        out.writeObject(new Long(this.stamp));
        out.writeObject(this.object);
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.key = (String)in.readObject();
        this.timeout = (Long)in.readObject();
        this.stamp = (Long)in.readObject();
        this.object = in.readObject();
    }
}

