/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.extensibility.SubComponentEvaluation;
import org.springframework.extensions.surf.extensibility.SubComponentEvaluator;
import org.springframework.extensions.surf.uri.UriUtils;

public class DefaultSubComponentEvaluation
implements SubComponentEvaluation {
    private static final Log logger = LogFactory.getLog(DefaultSubComponentEvaluation.class);
    private String id;
    private String uri = null;
    private Map<String, String> properties = new HashMap<String, String>();
    private List<Object[]> evaluatorData = new ArrayList<Object[]>();
    private boolean renderIfEvaluated = true;

    public DefaultSubComponentEvaluation(String id, boolean renderIfEvaluated) {
        this.id = id;
        this.renderIfEvaluated = renderIfEvaluated;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addEvaluator(String evaluatorId, Map<String, String> evaluationParams, boolean negate) {
        Object[] data = new Object[]{evaluatorId, evaluationParams, negate};
        this.evaluatorData.add(data);
    }

    @Override
    public boolean evaluate(RequestContext context, ApplicationContext applicationContext) {
        boolean allPass = true;
        for (Object[] data : this.evaluatorData) {
            String evaluatorId = (String)data[0];
            if (evaluatorId != null) {
                try {
                    SubComponentEvaluator evaluator = (SubComponentEvaluator)applicationContext.getBean(evaluatorId, SubComponentEvaluator.class);
                    HashMap<String, String> tokenizedParams = new HashMap<String, String>();
                    Map evaluatorParams = (Map)data[1];
                    for (Map.Entry prop : evaluatorParams.entrySet()) {
                        tokenizedParams.put((String)prop.getKey(), UriUtils.replaceTokens((String)prop.getValue(), context, null, null, ""));
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Evaluating: " + evaluatorId));
                    }
                    boolean evaluatedTrue = evaluator.evaluate(context, tokenizedParams);
                    if (((Boolean)data[2]).booleanValue()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Negating evaluator result of '" + evaluatedTrue + "' for: " + evaluatorId));
                        }
                        evaluatedTrue = !evaluatedTrue;
                    }
                    if (allPass = allPass && evaluatedTrue) continue;
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)("It was not possible to find " + SubComponentEvaluator.class.getName() + " with the id '" + evaluatorId + "' in the Spring application context"), (Throwable)e);
                    }
                    allPass = false;
                }
                catch (BeanNotOfRequiredTypeException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)("The bean with the id '" + evaluatorId + "' was not an instance of " + SubComponentEvaluator.class.getName()), (Throwable)e);
                    }
                    allPass = false;
                }
                catch (BeansException e) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)("The following exception occurred trying to retrieve " + SubComponentEvaluator.class.getName() + " with the id '" + evaluatorId + "' in the Spring application context"), (Throwable)e);
                    }
                    allPass = false;
                }
                break;
            }
            if (!logger.isWarnEnabled()) continue;
            logger.warn((Object)("A " + DefaultSubComponentEvaluation.class.getName() + " has been configured with a null " + SubComponentEvaluator.class.getName()));
        }
        return allPass;
    }

    @Override
    public boolean renderIfEvaluated() {
        return this.renderIfEvaluated;
    }
}

