/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class GeneratorController
extends AbstractController {
    private static Log logger = LogFactory.getLog(GeneratorController.class);
    public static final String TEMPLATE = "<extension>\n  <modules>\n    <module>\n      <id>${id}</id>\n      <auto-deploy>true</auto-deploy>\n      <evaluator type=\"default.extensibility.evaluator\"/>\n      <customizations>\n        <customization>\n           <targetPackageRoot>${target}</targetPackageRoot>\n           <sourcePackageRoot>${source}</sourcePackageRoot>\n        </customization>\n      </customizations>\n    </module>\n  </modules>\n</extension>";
    public static final String CONTROLLER_TEMPLATE = "// Add JavaScript to modify the JSON model for the page";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = null;
        try {
            int c;
            int index;
            String path = "";
            String fileName = "";
            String webscriptId = request.getParameter("webscriptId");
            if (webscriptId != null && (index = webscriptId.lastIndexOf("/")) != -1) {
                path = webscriptId.substring(0, index);
                fileName = webscriptId.substring(index);
            }
            String s = TEMPLATE;
            s = s.replace("${id}", "Extension Module");
            s = s.replace("${target}", path.replace("/", "."));
            s = s.replace("${source}", path.replace("/", ".") + ".customization");
            zos = new ZipOutputStream(baos);
            ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));
            InputStreamReader isr = new InputStreamReader(stream);
            ZipEntry ze = new ZipEntry("alfresco/site-data/extensions/extension.xml");
            zos.putNextEntry(ze);
            while ((c = isr.read()) != -1) {
                zos.write(c);
            }
            zos.closeEntry();
            ze = new ZipEntry("alfresco/site-webscripts/" + path + "/customization" + fileName + ".js");
            zos.putNextEntry(ze);
            stream = new ByteArrayInputStream(CONTROLLER_TEMPLATE.getBytes(StandardCharsets.UTF_8));
            isr = new InputStreamReader(stream);
            while ((c = isr.read()) != -1) {
                zos.write(c);
            }
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry("META-INF/."));
        }
        catch (IOException e) {
            logger.error((Object)"The following error occurred attempting to generate an extension module JAR", (Throwable)e);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"The following error occurred attempting to close a ZipOutputStream for a generated extension module JAR file", (Throwable)e);
            }
        }
        String filename = "Extension.jar";
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        response.setContentType("application/zip");
        response.setHeader("Content-Transfer-Encoding", "binary");
        try {
            response.getOutputStream().write(baos.toByteArray());
        }
        catch (IOException e) {
            logger.error((Object)"The following error occurred attempting write the contents of a generated extension module JAR file", (Throwable)e);
        }
        finally {
            baos.close();
        }
        return null;
    }
}

