/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.extensions.surf.mvc.AbstractLoginController;
import org.springframework.extensions.surf.uri.UriUtils;

public class LoginController
extends AbstractLoginController {
    protected static final String PARAM_FAILURE = "failure";
    protected static final String PARAM_SUCCESS = "success";

    @Override
    protected void onSuccess(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String successPage = request.getParameter(PARAM_SUCCESS);
        if (successPage != null) {
            response.sendRedirect(UriUtils.relativeUri(successPage));
        } else {
            response.sendRedirect(request.getContextPath());
        }
    }

    @Override
    protected void onFailure(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String failurePage = request.getParameter(PARAM_FAILURE);
        request.getSession().invalidate();
        if (failurePage != null) {
            response.sendRedirect(UriUtils.relativeUri(failurePage));
        } else {
            response.sendRedirect(request.getContextPath());
        }
    }
}

