/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.mvc;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkViewResolver;
import org.springframework.extensions.surf.mvc.PageView;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Page;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class PageViewResolver
extends AbstractWebFrameworkViewResolver {
    private ReadWriteLock uriIndexListLock = new ReentrantReadWriteLock();
    static final String URI_PAGEID = "pageid";

    public PageViewResolver() {
        this.useNullSentinel = false;
    }

    @Override
    protected boolean canHandle(String viewName, Locale locale) {
        boolean canHandle = false;
        Page page = null;
        RequestContext currentRequestContext = ThreadLocalRequestContext.getRequestContext();
        String pageRequested = viewName;
        String servletContextPath = currentRequestContext.getServletContextPath();
        if (servletContextPath != null) {
            if (!viewName.startsWith("/")) {
                servletContextPath = servletContextPath.substring(1);
            }
            if (viewName.startsWith(servletContextPath)) {
                pageRequested = viewName.substring(servletContextPath.length());
            }
        }
        if (pageRequested.length() == 0 || pageRequested.length() == 1 && pageRequested.charAt(0) == '/') {
            page = currentRequestContext.getRootPage();
            currentRequestContext.setPage(page);
            currentRequestContext.setUriTokens(this.getTokens(page.getId()));
            canHandle = true;
        } else {
            String pageId = viewName;
            Map<String, String> tokens = this.getTokens(viewName);
            if (tokens != null) {
                if (tokens.containsKey(URI_PAGEID)) {
                    pageId = tokens.get(URI_PAGEID);
                }
                currentRequestContext.setUriTokens(tokens);
            }
            if ((page = this.lookupPage(pageId)) != null) {
                currentRequestContext.setPage(page);
                canHandle = true;
            }
        }
        return canHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getTokens(String viewName) {
        Map<String, String> tokens = null;
        this.uriIndexListLock.readLock().lock();
        try {
            if (this.getUriTemplateListIndex() == null) {
                this.uriIndexListLock.readLock().unlock();
                this.uriIndexListLock.writeLock().lock();
                try {
                    if (this.getUriTemplateListIndex() == null) {
                        this.setUriTemplateIndex(this.generateUriTemplateListIndexFromConfig(this.getWebFrameworkServiceRegistry(), "uri-templates"));
                    }
                }
                finally {
                    this.uriIndexListLock.readLock().lock();
                    this.uriIndexListLock.writeLock().unlock();
                }
            }
            tokens = this.matchUriTemplate("/" + viewName);
        }
        finally {
            this.uriIndexListLock.readLock().unlock();
        }
        return tokens;
    }

    protected AbstractUrlBasedView buildView(String viewName) {
        PageView view = null;
        Page page = ThreadLocalRequestContext.getRequestContext().getPage();
        if (page != null) {
            view = new PageView(this.getWebframeworkConfigElement(), this.getModelObjectService(), this.getWebFrameworkResourceService(), this.getWebFrameworkRenderService(), this.getTemplatesContainer());
            view.setUrl(viewName);
            view.setPage(page);
            view.setUrlHelperFactory(this.getUrlHelperFactory());
            view.setUriTokens(ThreadLocalRequestContext.getRequestContext().getUriTokens());
        }
        return view;
    }
}

