/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render.bean;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.RendererExecutionException;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.impl.ExtensibilityHttpResponse;
import org.springframework.extensions.surf.render.AbstractProcessor;
import org.springframework.extensions.surf.render.ProcessorContext;
import org.springframework.extensions.surf.render.RenderContextRequest;
import org.springframework.extensions.surf.site.RequestUtil;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.web.context.ServletContextAware;

public class JSPProcessor
extends AbstractProcessor
implements ServletContextAware {
    private static final Log logger = LogFactory.getLog(JSPProcessor.class);
    private static final String JSP_FILE_URI = "jsp-file-uri";
    private static final String JSP_PATH_URI = "jsp-path-uri";
    private static final String _JSP_PATH = "jsp-path";
    protected ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void executeHeader(ProcessorContext pc, ModelObject object) throws RendererExecutionException {
        RequestContext context = pc.getRequestContext();
        Object jspPath = this.getJspPath(pc);
        try {
            if (jspPath != null) {
                URL resource;
                int x = ((String)jspPath).lastIndexOf(46);
                if (x != -1) {
                    jspPath = ((String)jspPath).substring(0, x) + ".head." + ((String)jspPath).substring(x + 1, ((String)jspPath).length());
                }
                if ((resource = this.servletContext.getResource((String)jspPath)) != null) {
                    Object response = null;
                    ExtensibilityModel extModel = context.getCurrentExtensibilityModel();
                    response = extModel == null ? context.getResponse() : new ExtensibilityHttpResponse(context.getResponse(), extModel);
                    RequestUtil.include(ServletUtil.getRequest(), response, (String)jspPath);
                }
            }
        }
        catch (Exception ex) {
            throw new RendererExecutionException("Unable to execute 'header' JSP Include: " + (String)jspPath, ex);
        }
    }

    @Override
    public void executeBody(ProcessorContext pc, ModelObject object) throws RendererExecutionException {
        RequestContext context = pc.getRequestContext();
        String jspPath = this.getJspPath(pc);
        try {
            context.setValue(JSP_FILE_URI, (Serializable)((Object)jspPath));
            int x = jspPath.lastIndexOf(47);
            if (x != -1) {
                String pathUri = jspPath.substring(0, x);
                context.setValue(JSP_PATH_URI, (Serializable)((Object)pathUri));
            } else {
                context.setValue(JSP_PATH_URI, (Serializable)((Object)"/"));
            }
            this.doInclude(context, object, jspPath);
        }
        catch (Exception ex) {
            throw new RendererExecutionException("Unable to execute 'body' JSP include: " + jspPath, ex);
        }
    }

    private String getJspPath(ProcessorContext pc) {
        String jspPath = this.getProperty(pc, "uri");
        if (jspPath == null) {
            jspPath = this.getProperty(pc, _JSP_PATH);
        }
        if (jspPath == null) {
            logger.error((Object)"Could not retrieve a URI for the JSP to render. Please ensure that the property \"uri\" is set in the ProcessorContext");
        }
        return jspPath;
    }

    @Override
    public boolean exists(ProcessorContext pc, ModelObject object) {
        boolean exists = false;
        String jspPath = this.getJspPath(pc);
        try {
            URL resource = this.servletContext.getResource(jspPath);
            exists = resource != null;
        }
        catch (MalformedURLException e) {
            logger.error((Object)("The URI for the JSP was badly formed: " + jspPath));
        }
        return exists;
    }

    protected void doInclude(RequestContext context, ModelObject object, String jspPath) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = ServletUtil.getRequest();
        RenderContextRequest request = new RenderContextRequest(context, object, httpServletRequest);
        RequestDispatcher dispatcher = request.getRequestDispatcher(jspPath);
        Object response = null;
        ExtensibilityModel extModel = context.getCurrentExtensibilityModel();
        response = extModel == null ? context.getResponse() : new ExtensibilityHttpResponse(context.getResponse(), extModel);
        if (object != null && object instanceof TemplateInstance) {
            if (!response.isCommitted()) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            } else {
                logger.warn((Object)("Unable to forward to '" + jspPath + "' as response already committed."));
            }
        } else {
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
    }
}

