/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.support;

import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigImpl;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.config.evaluator.Evaluator;
import org.springframework.extensions.config.xml.XMLConfigService;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.LinkBuilder;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.ExtensibilityModuleHandler;
import org.springframework.extensions.surf.extensibility.HandlesExtensibility;
import org.springframework.extensions.surf.extensibility.impl.ExtensibilityModelImpl;
import org.springframework.extensions.surf.render.RenderMode;
import org.springframework.extensions.surf.resource.Resource;
import org.springframework.extensions.surf.site.SiteUtil;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.Configuration;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.SubComponent;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.surf.types.Theme;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.FakeHttpServletResponse;
import org.springframework.extensions.webscripts.ExtendedScriptConfigModel;
import org.springframework.extensions.webscripts.ExtendedTemplateConfigModel;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.extensions.webscripts.TemplateConfigModel;
import org.springframework.extensions.webscripts.WebScriptPropertyResourceBundle;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.User;
import org.springframework.web.context.request.WebRequest;

public abstract class AbstractRequestContext
extends ThreadLocalRequestContext
implements HandlesExtensibility {
    private static final Log logger = LogFactory.getLog(AbstractRequestContext.class);
    private static final long serialVersionUID = -3714605386235121796L;
    public static final String VALUE_HEAD_TAGS = "headTags";
    protected static AtomicLong counter = new AtomicLong();
    protected Map<String, Serializable> valuesMap;
    protected Map<String, String> parametersMap;
    protected Map<String, Serializable> attributesMap;
    protected Map<String, String> headersMap;
    protected Map<String, String> uriTokens = Collections.emptyMap();
    protected Page rootPage;
    protected Configuration siteConfiguration;
    protected Page currentPage;
    protected TemplateInstance currentTemplate;
    protected Resource currentResource;
    protected String currentFormatId;
    protected String storeId;
    protected User user;
    protected String id;
    protected String uri;
    protected String viewName;
    protected Theme theme;
    protected Map<String, Component> components = null;
    protected Map<String, Object> model;
    protected String method;
    protected String scheme;
    protected String contextPath;
    private FrameworkBean frameworkUtil;
    private ModelObject object;
    private WebRequest request;
    private HttpServletResponse response;
    private RenderMode mode = RenderMode.VIEW;
    private String renderId = null;
    private boolean passiveMode = false;
    private FakeHttpServletResponse fakeResponse;
    private String servletContextPath = null;
    private ExtensibilityModel extensibilityModel;
    private Map<String, Serializable> evaluatedProperties = new HashMap<String, Serializable>();
    private DependencyHandler dependencyHandler = null;
    private ExtensibilityModuleHandler extensibilityModuleHandler = null;
    private WebFrameworkConfigElement webFrameworkConfigElement;
    private ConfigService configService;
    private List<ExtensionModule> evaluatedModules = null;
    private LinkedHashSet<String> extensionModuleJsDependencies = new LinkedHashSet();
    private Map<String, LinkedHashSet<String>> extensionModuleCssDependencies = new HashMap<String, LinkedHashSet<String>>();
    private Set<String> requestedDependencies = new HashSet<String>();
    private String fileBeingProcessed = null;
    private Map<String, SubComponent.RenderData> subComponentDebugData = new HashMap<String, SubComponent.RenderData>();
    private Map<String, WebScriptPropertyResourceBundle> extendedBundleCache = new HashMap<String, WebScriptPropertyResourceBundle>();
    private ConfigImpl globalConfig = null;
    private Map<String, List<ConfigSection>> sectionsByArea = null;
    private List<ConfigSection> sections = null;

    protected AbstractRequestContext(WebFrameworkServiceRegistry serviceRegistry, FrameworkBean frameworkUtil) {
        super(serviceRegistry);
        this.frameworkUtil = frameworkUtil;
        this.valuesMap = new HashMap<String, Serializable>(4, 1.0f);
        this.parametersMap = new HashMap<String, String>(4, 1.0f);
        this.attributesMap = new HashMap<String, Serializable>(4, 1.0f);
        this.headersMap = new CaseInsensitiveHeadersMap<String, String>(16, 1.0f);
        this.components = new LinkedHashMap<String, Component>(16, 1.0f);
        this.model = new HashMap<String, Object>(16);
    }

    protected AbstractRequestContext(WebFrameworkServiceRegistry serviceRegistry) {
        this(serviceRegistry, null);
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = Long.toString(counter.incrementAndGet());
        }
        return this.id;
    }

    @Override
    public Configuration getSiteConfiguration() {
        if (this.siteConfiguration == null) {
            this.siteConfiguration = SiteUtil.getSiteConfiguration(this);
        }
        return this.siteConfiguration;
    }

    @Override
    public String getWebsiteTitle() {
        String title = "Web Application";
        if (this.getSiteConfiguration() != null) {
            title = this.getSiteConfiguration().getTitle();
        }
        return title;
    }

    @Override
    public String getPageTitle() {
        String title = "Default Page";
        if (this.getPage() != null) {
            title = this.getPage().getTitle();
        }
        return title;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public Page getPage() {
        return this.currentPage;
    }

    @Override
    public void setPage(Page page) {
        this.currentPage = page;
        this.currentTemplate = null;
    }

    @Override
    public String getPageId() {
        if (this.getPage() != null) {
            return this.getPage().getId();
        }
        return null;
    }

    @Override
    public abstract LinkBuilder getLinkBuilder();

    @Override
    public Page getRootPage() {
        if (this.rootPage == null) {
            this.rootPage = SiteUtil.getRootPage(this);
        }
        return this.rootPage;
    }

    @Override
    public TemplateInstance getTemplate() {
        if (this.currentTemplate == null && this.getPage() != null) {
            this.currentTemplate = this.getPage().getTemplate(this);
        }
        return this.currentTemplate;
    }

    @Override
    public void setTemplate(TemplateInstance currentTemplate) {
        this.currentTemplate = currentTemplate;
    }

    @Override
    public String getTemplateId() {
        if (this.getTemplate() != null) {
            return this.getTemplate().getId();
        }
        return null;
    }

    @Override
    public String getCurrentObjectId() {
        String id = null;
        if (this.getCurrentObject() != null) {
            id = this.getCurrentObject().getObjectId();
        }
        return id;
    }

    @Override
    public void setCurrentObject(Resource resource) {
        this.currentResource = resource;
    }

    @Override
    public Resource getCurrentObject() {
        return this.currentResource;
    }

    @Override
    public String getFormatId() {
        return this.currentFormatId;
    }

    @Override
    public void setFormatId(String formatId) {
        this.currentFormatId = formatId;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String getUserId() {
        return this.getUser() != null ? this.getUser().getId() : null;
    }

    @Override
    public CredentialVault getCredentialVault() {
        CredentialVault credentialVault = this.frameworkUtil == null ? FrameworkUtil.getCredentialVault(this, this.getUserId()) : this.frameworkUtil.getCredentialVault(this, this.getUserId());
        return credentialVault;
    }

    @Override
    public void setValue(String key, Serializable value) {
        this.valuesMap.put(key, value);
    }

    @Override
    public Serializable getValue(String key) {
        return this.valuesMap.get(key);
    }

    @Override
    public void removeValue(String key) {
        this.valuesMap.remove(key);
    }

    @Override
    public boolean hasValue(String key) {
        return this.valuesMap.get(key) != null;
    }

    @Override
    public Map<String, Serializable> getValuesMap() {
        return this.valuesMap;
    }

    @Override
    public String getParameter(String key) {
        return this.parametersMap.get(key);
    }

    @Override
    public boolean hasParameter(String key) {
        return this.parametersMap.get(key) != null;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parametersMap;
    }

    @Override
    public Component[] getRenderingComponents() {
        if (this.components.size() == 0) {
            return null;
        }
        return this.components.values().toArray(new Component[this.components.size()]);
    }

    @Override
    public void setRenderingComponent(Component component) {
        this.components.put(component.getId(), component);
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    @Override
    public String getThemeId() {
        String themeId = null;
        if (this.getTheme() != null) {
            themeId = this.getTheme().getId();
        }
        return themeId;
    }

    @Override
    public String getRequestMethod() {
        return this.method;
    }

    @Override
    public String getRequestScheme() {
        return this.scheme;
    }

    @Override
    public ModelObjectService getObjectService() {
        return this.getServiceRegistry().getModelObjectService();
    }

    public String toString() {
        return "RequestContext-" + this.getId();
    }

    @Override
    public void setModel(Map<String, Object> model) {
        this.model = model;
    }

    @Override
    public Map<String, Object> getModel() {
        return this.model;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public Serializable getAttribute(String key) {
        return this.attributesMap.get(key);
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.attributesMap.get(key) != null;
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributesMap;
    }

    @Override
    public String getHeader(String key) {
        return this.headersMap.get(key);
    }

    @Override
    public boolean hasHeader(String key) {
        return this.headersMap.get(key) != null;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headersMap;
    }

    @Override
    public void setUriTokens(Map<String, String> _uriTokens) {
        this.uriTokens = _uriTokens != null ? _uriTokens : Collections.emptyMap();
    }

    @Override
    public Map<String, String> getUriTokens() {
        return this.uriTokens;
    }

    @Override
    public synchronized Content getRequestContent() {
        return null;
    }

    @Override
    public final RenderMode getRenderMode() {
        return this.mode;
    }

    @Override
    public final void setRenderMode(RenderMode mode) {
        this.mode = mode;
    }

    public final WebRequest getRequest() {
        return this.request;
    }

    public final void setRequest(WebRequest request) {
        this.request = request;
    }

    @Override
    public final HttpServletResponse getResponse() {
        FakeHttpServletResponse responseToReturn = null;
        responseToReturn = this.passiveMode ? this.fakeResponse : this.response;
        return responseToReturn;
    }

    @Override
    public String getContentAsString() throws UnsupportedEncodingException {
        return this.fakeResponse.getContentAsString();
    }

    @Override
    public final void setResponse(HttpServletResponse response) {
        this.response = response;
        this.fakeResponse = new FakeHttpServletResponse(response);
    }

    public ModelObject getObject() {
        return this.object;
    }

    public void setObject(ModelObject object) {
        this.object = object;
    }

    @Override
    public final void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
        if (passiveMode) {
            this.fakeResponse = new FakeHttpServletResponse(this.response);
        }
    }

    @Override
    public final boolean isPassiveMode() {
        return this.passiveMode;
    }

    @Override
    public String getServletContextPath() {
        return this.servletContextPath;
    }

    @Override
    public void setServletContextPath(String path) {
        this.servletContextPath = path;
    }

    public ExtensibilityModel openExtensibilityModel() {
        this.extensibilityModel = new ExtensibilityModelImpl(this.extensibilityModel, (HandlesExtensibility)this);
        return this.extensibilityModel;
    }

    public void closeExtensibilityModel(ExtensibilityModel model, Writer out) {
        model.flushModel(out);
        this.extensibilityModel = model.getParentModel();
        if (this.extensibilityModel != null) {
            this.extensibilityModel.setChildDebugData(model.getDebugData());
        }
    }

    public ExtensibilityModel getCurrentExtensibilityModel() {
        return this.extensibilityModel;
    }

    @Override
    public void setEvaluatedProperties(Map<String, Serializable> properties) {
        this.evaluatedProperties.clear();
        this.evaluatedProperties.putAll(properties);
    }

    @Override
    public Map<String, Serializable> getEvaluatedProperties() {
        return this.evaluatedProperties;
    }

    @Override
    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    @Override
    public void setExtensibilityModuleHandler(ExtensibilityModuleHandler extensibilityModuleHandler) {
        this.extensibilityModuleHandler = extensibilityModuleHandler;
    }

    @Override
    public void setWebFrameworkConfigElement(WebFrameworkConfigElement webFrameworkConfigElement) {
        this.webFrameworkConfigElement = webFrameworkConfigElement;
    }

    @Override
    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    @Override
    public List<ExtensionModule> getEvaluatedModules() {
        if (!this.webFrameworkConfigElement.isGuestPageExtensionModulesEnabled() && this.user.isGuest()) {
            this.evaluatedModules = new ArrayList<ExtensionModule>();
        } else if (this.evaluatedModules == null) {
            if (this.extensibilityModuleHandler == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"No 'extensibilityModuleHandler' has been configured for this request context. Extensions cannot be processed");
                }
                this.evaluatedModules = new ArrayList<ExtensionModule>();
            } else {
                this.evaluatedModules = this.extensibilityModuleHandler.evaluateModules(this);
            }
        }
        return this.evaluatedModules;
    }

    @Override
    public void addJSDependency(String dependency) {
        if (!this.requestedDependencies.contains(dependency)) {
            this.requestedDependencies.add(dependency);
            this.extensionModuleJsDependencies.add(dependency);
        }
    }

    @Override
    public void addCssDependency(String dependency, String media) {
        if (!this.requestedDependencies.contains(dependency)) {
            this.requestedDependencies.add(dependency);
            LinkedHashSet<String> mediaSpecificDependencies = this.extensionModuleCssDependencies.get(media);
            if (mediaSpecificDependencies == null) {
                mediaSpecificDependencies = new LinkedHashSet();
                this.extensionModuleCssDependencies.put(media, mediaSpecificDependencies);
            }
            mediaSpecificDependencies.add(dependency);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getExtensionDependencies() {
        StringBuilder dependencies = new StringBuilder();
        if (!this.extensionModuleJsDependencies.isEmpty() || !this.extensionModuleCssDependencies.isEmpty()) {
            dependencies.append("\n\n   <!-- Extension Module Dependencies -->\n\n");
            for (String string : this.extensionModuleJsDependencies) {
                String checksumPath = null;
                if (this.webFrameworkConfigElement.useChecksumDependencies()) {
                    void var3_3;
                    if (string.startsWith(this.dependencyHandler.getResourceControllerMapping() + "/")) {
                        String string2 = string.substring(this.dependencyHandler.getResourceControllerMapping().length() + 1);
                    }
                    if ((checksumPath = this.dependencyHandler.getChecksumPath((String)var3_3)) != null) {
                        dependencies.append("   <script type=\"text/javascript\" src=\"");
                        dependencies.append(this.getContextPath());
                        dependencies.append(this.dependencyHandler.getResourceControllerMapping());
                        dependencies.append("/");
                        dependencies.append(checksumPath);
                        dependencies.append("\"></script>");
                        dependencies.append("\n");
                        continue;
                    }
                    dependencies.append("   <!-- Could not find JavaScript dependency: \"");
                    dependencies.append((String)var3_3);
                    dependencies.append("\" -->\n");
                    continue;
                }
                dependencies.append("   <script type=\"text/javascript\" src=\"");
                if (string.startsWith("/")) {
                    dependencies.append(this.getContextPath());
                }
                dependencies.append(string);
                dependencies.append("\"></script>");
                dependencies.append("\n");
            }
            if (!this.extensionModuleCssDependencies.isEmpty()) {
                for (Map.Entry entry : this.extensionModuleCssDependencies.entrySet()) {
                    int count = 0;
                    dependencies.append("   <style type=\"text/css\" media=\"");
                    dependencies.append((String)entry.getKey());
                    dependencies.append("\">\n");
                    for (String cssDep : (LinkedHashSet)entry.getValue()) {
                        String checksumPath = null;
                        if (this.webFrameworkConfigElement.useChecksumDependencies()) {
                            if (cssDep.startsWith(this.dependencyHandler.getResourceControllerMapping() + "/")) {
                                cssDep = cssDep.substring(this.dependencyHandler.getResourceControllerMapping().length() + 1);
                            }
                            if ((checksumPath = this.dependencyHandler.getChecksumPath(cssDep)) != null) {
                                ++count;
                                dependencies.append("      @import url(\"");
                                dependencies.append(this.getContextPath());
                                dependencies.append(this.dependencyHandler.getResourceControllerMapping());
                                dependencies.append("/");
                                dependencies.append(checksumPath);
                                dependencies.append("\");\n");
                                if (count != 31) continue;
                                dependencies.append("   </style>\n\n");
                                dependencies.append("   <style type=\"text/css\" media=\"");
                                dependencies.append((String)entry.getKey());
                                dependencies.append("\">\n");
                                count = 0;
                                continue;
                            }
                            dependencies.append("      /* Could not find CSS dependency: \"");
                            dependencies.append(cssDep);
                            dependencies.append("\" */\n");
                            continue;
                        }
                        dependencies.append("      @import url(\"");
                        if (cssDep.startsWith("/")) {
                            dependencies.append(this.getContextPath());
                        }
                        dependencies.append(cssDep);
                        dependencies.append("\");\n");
                    }
                    dependencies.append("   </style>\n\n");
                }
            }
        }
        return dependencies.toString();
    }

    public void updateExtendingModuleDependencies(String path, Map<String, Object> model) {
        for (ExtensionModule module : this.getEvaluatedModules()) {
            for (String string : this.extensibilityModuleHandler.getModuleJsDeps(module, path)) {
                if (this.requestedDependencies.contains(string)) continue;
                this.extensionModuleJsDependencies.add(string);
                this.requestedDependencies.add(string);
            }
        }
        for (ExtensionModule module : this.getEvaluatedModules()) {
            for (Map.Entry entry : this.extensibilityModuleHandler.getModuleCssDeps(module, path).entrySet()) {
                for (String dep : (LinkedHashSet)entry.getValue()) {
                    if (this.requestedDependencies.contains(dep)) continue;
                    LinkedHashSet<String> mediaSpecificDependencies = this.extensionModuleCssDependencies.get(entry.getKey());
                    if (mediaSpecificDependencies == null) {
                        mediaSpecificDependencies = new LinkedHashSet();
                        this.extensionModuleCssDependencies.put((String)entry.getKey(), mediaSpecificDependencies);
                    }
                    mediaSpecificDependencies.add(dep);
                    this.requestedDependencies.add(dep);
                }
            }
        }
    }

    public List<String> getExtendingModuleFiles(String pathBeingProcessed) {
        ArrayList<String> extendingModuleFiles = new ArrayList<String>();
        for (ExtensionModule module : this.getEvaluatedModules()) {
            extendingModuleFiles.addAll(this.extensibilityModuleHandler.getExtendingModuleFiles(module, pathBeingProcessed));
        }
        return extendingModuleFiles;
    }

    @Override
    public boolean dependencyAlreadyRequested(String dep) {
        return this.requestedDependencies.contains(dep);
    }

    @Override
    public void markDependencyAsRequested(String dep) {
        this.requestedDependencies.add(dep);
    }

    public String getFileBeingProcessed() {
        return this.fileBeingProcessed;
    }

    public void setFileBeingProcessed(String file) {
        this.fileBeingProcessed = file;
    }

    @Override
    public SubComponent.RenderData getSubComponentDebugData(String id) {
        SubComponent.RenderData data = this.subComponentDebugData.get(id);
        return data;
    }

    @Override
    public void addSubComponentDebugData(String id, SubComponent.RenderData data) {
        this.subComponentDebugData.put(id, data);
    }

    public ResourceBundle getCachedExtendedBundle(String webScriptId) {
        return (ResourceBundle)this.extendedBundleCache.get(webScriptId);
    }

    public void addExtensionBundleToCache(String webScriptId, WebScriptPropertyResourceBundle extensionBundle) {
        this.extendedBundleCache.put(webScriptId, extensionBundle);
    }

    public ScriptConfigModel getExtendedScriptConfigModel(String xmlConfig) {
        if (this.globalConfig == null && this.sectionsByArea == null && this.sections == null) {
            this.getConfigExtensions();
        }
        return new ExtendedScriptConfigModel(this.configService, xmlConfig, this.globalConfig, this.sectionsByArea, this.sections);
    }

    public TemplateConfigModel getExtendedTemplateConfigModel(String xmlConfig) {
        if (this.globalConfig == null && this.sectionsByArea == null && this.sections == null) {
            this.getConfigExtensions();
        }
        return new ExtendedTemplateConfigModel(this.configService, xmlConfig, this.globalConfig, this.sectionsByArea, this.sections);
    }

    private void getConfigExtensions() {
        if (this.configService instanceof XMLConfigService && this.globalConfig == null && this.sectionsByArea == null && this.sections == null) {
            XMLConfigService xmlConfigService = (XMLConfigService)this.configService;
            this.globalConfig = new ConfigImpl((ConfigImpl)xmlConfigService.getGlobalConfig());
            this.sectionsByArea = new HashMap<String, List<ConfigSection>>(xmlConfigService.getSectionsByArea());
            this.sections = new ArrayList<ConfigSection>(xmlConfigService.getSections());
            List<ExtensionModule> evaluatedModules = this.getEvaluatedModules();
            if (evaluatedModules != null && !evaluatedModules.isEmpty()) {
                for (ExtensionModule currModule : evaluatedModules) {
                    for (Element currentConfigElement : currModule.getConfigurations()) {
                        HashMap<String, ConfigElementReader> parsedElementReaders = new HashMap<String, ConfigElementReader>();
                        HashMap<String, Evaluator> parsedEvaluators = new HashMap<String, Evaluator>();
                        ArrayList parsedConfigSections = new ArrayList();
                        String currentArea = xmlConfigService.parseFragment(currentConfigElement, parsedElementReaders, parsedEvaluators, parsedConfigSections);
                        for (Map.Entry entry : parsedEvaluators.entrySet()) {
                            parsedEvaluators.put((String)entry.getKey(), (Evaluator)entry.getValue());
                        }
                        for (Map.Entry entry : parsedElementReaders.entrySet()) {
                            parsedElementReaders.put((String)entry.getKey(), (ConfigElementReader)entry.getValue());
                        }
                        for (ConfigSection section : parsedConfigSections) {
                            xmlConfigService.addConfigSection(section, currentArea, this.globalConfig, this.sectionsByArea, this.sections);
                        }
                    }
                }
            }
        }
    }

    public void addExtensibilityDirectives(Map<String, Object> freeMarkerModel, ExtensibilityModel extModel) {
    }

    private static class CaseInsensitiveHeadersMap<K, V>
    extends HashMap<K, V> {
        public CaseInsensitiveHeadersMap() {
        }

        public CaseInsensitiveHeadersMap(int initialCapacity) {
            super(initialCapacity);
        }

        public CaseInsensitiveHeadersMap(Map<? extends K, ? extends V> m) {
            super(m);
        }

        public CaseInsensitiveHeadersMap(int i, float f) {
            super(i, f);
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key.toString().toLowerCase());
        }

        @Override
        public V get(Object key) {
            return super.get(key.toString().toLowerCase());
        }

        @Override
        public V put(K key, V value) {
            return super.put(key.toString().toLowerCase(), value);
        }
    }
}

