/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTypeChildrenTests
extends CmisTest {
    @BeforeClass(alwaysRun=true)
    public void setup() throws Exception {
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser());
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify admin can get type children for BaseTypeId.CMIS_DOCUMENT and includePropertyDefinitions = false")
    @Test(groups={"cmis", "sanity"})
    public void getTypeChildrenWithoutPropertyDefinitions() {
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingObjectType(BaseTypeId.CMIS_DOCUMENT.value()).withoutPropertyDefinitions().hasChildren("D:srft:facetField").propertyDefinitionIsEmpty();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify admin can get type children for valid type id and includePropertyDefinitions = true")
    @Test(groups={"cmis", "sanity"})
    public void getTypeChildrenWithPropertyDefinitions() {
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingObjectType(BaseTypeId.CMIS_FOLDER.value()).withPropertyDefinitions().hasChildren("F:pub:DeliveryChannel").propertyDefinitionIsNotEmpty();
        this.cmisApi.usingObjectType(BaseTypeId.CMIS_FOLDER.value()).withPropertyDefinitions().doesNotHaveChildren("D:srft:facetField");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can get invalid type children for valid type id")
    @Test(groups={"cmis", "regression"})
    public void getInvalidTypeChildrenForATypeId() {
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingObjectType(BaseTypeId.CMIS_FOLDER.value()).withPropertyDefinitions().doesNotHaveChildren("F:pub:invalidDeliveryChannelv");
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify admin can get valid type children for invalid type id")
    @Test(groups={"cmis", "regression"}, expectedExceptions={CmisObjectNotFoundException.class}, expectedExceptionsMessageRegExp="Type 'cmis:invalidfolder' is unknown!*")
    public void getValidTypeChildrenForInvalidTypeId() {
        this.cmisApi.authenticateUser(this.dataUser.getAdminUser()).usingObjectType("cmis:invalidfolder").withPropertyDefinitions().hasChildren("F:pub:DeliveryChannel").propertyDefinitionIsNotEmpty();
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify deleted user is not authorized to get type children for valid type id")
    @Test(groups={"cmis", "regression"}, expectedExceptions={CmisUnauthorizedException.class})
    public void getTypeChildrenWithWithDeletedUser() throws DataPreparationException {
        UserModel deletedUser = this.dataUser.createRandomTestUser();
        this.cmisApi.authenticateUser(deletedUser).usingObjectType(BaseTypeId.CMIS_FOLDER.value()).withPropertyDefinitions().hasChildren("F:pub:DeliveryChannel").propertyDefinitionIsNotEmpty();
        this.dataUser.deleteUser(deletedUser);
        this.cmisApi.disconnect().usingObjectType(BaseTypeId.CMIS_FOLDER.value()).withPropertyDefinitions().doesNotHaveChildren("D:srft:facetField");
    }

    @Bug(id="REPO-5388")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify disabled user is not authorized to get type children for valid type id")
    @Test(groups={"cmis", "regression"}, expectedExceptions={CmisUnauthorizedException.class})
    public void getTypeChildrenWithWithDisabledUser() throws DataPreparationException {
        UserModel disabledUser = this.dataUser.createRandomTestUser();
        this.cmisApi.authenticateUser(disabledUser).usingObjectType(BaseTypeId.CMIS_FOLDER.value()).withPropertyDefinitions().hasChildren("F:pub:DeliveryChannel").propertyDefinitionIsNotEmpty();
        ((DataUser)this.dataUser.usingAdmin()).disableUser(disabledUser);
        this.cmisApi.disconnect().usingObjectType(BaseTypeId.CMIS_FOLDER.value()).withPropertyDefinitions().doesNotHaveChildren("D:srft:facetField");
    }
}

