/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import java.io.IOException;
import javax.mail.Flags;
import javax.mail.MessagingException;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataCalendarEvent;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapReadMessagesTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        this.adminUser = this.dataUser.getAdminUser();
        this.adminSite = ((DataSite)this.dataSite.usingAdmin()).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify folders created in repository in other folder via IMAP client by admin user")
    @Test(groups={"protocols", "imap", "sanity"})
    public void adminShouldGetFoldersCreatedInRepositoryViaImap() throws Exception {
        this.testFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createFolder();
        FolderModel testFolder1 = FolderModel.getRandomFolderModel();
        FolderModel testFolder2 = FolderModel.getRandomFolderModel();
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.adminUser).usingSite(this.adminSite).usingResource((ContentModel)this.testFolder).createFolder(testFolder1).and()).assertThat().existsInRepo()).and()).assertThat().existsInImap().then()).usingResource((ContentModel)this.testFolder).createFolder(testFolder2).assertThat().existsInRepo()).and()).assertThat().existsInImap();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify file and its content are displayed via IMAP client when the file is created by site manager")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldGetFileAndItsContentsViaImap() throws Exception {
        FileModel fileModel = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).assertThat().containsMessages(new FileModel[]{fileModel}).and()).usingResource((ContentModel)fileModel).assertThat().existsInRepo()).then()).assertThat().fileContentIsDisplayed();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify that file content in IMAP client contains creator, title, description, created date, modifier, modified date, size, three links to content folder, to content url, to download url")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldVerifyFileContent() throws Exception {
        FileModel fileModel = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).assertThat().containsMessages(new FileModel[]{fileModel}).and()).usingResource((ContentModel)fileModel).assertThat().existsInRepo()).then()).assertThat().messageContentMatchesFileModelData(fileModel);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that the admin user can mark a message as read")
    @Test(groups={"protocols", "imap", "core"})
    public void adminCanMarkMessageAsRead() throws Exception {
        this.testFile = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.adminSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        ((ImapWrapper)this.imapProtocol.authenticateUser(this.adminUser).usingResource((ContentModel)this.testFile).withMessage().setSeenFlag().updateFlags().then()).assertThat().messageContainsFlags(new Flags.Flag[]{Flags.Flag.SEEN});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator can see files created by self")
    @Test(groups={"protocols", "imap", "core"})
    public void collaboratorCanViewFileCreatedBySelf() throws Exception {
        UserModel collaboratorUser = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(collaboratorUser, this.testSite, UserRole.SiteCollaborator);
        this.testFile = ((DataContent)this.dataContent.usingUser(collaboratorUser).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.imapProtocol.authenticateUser(collaboratorUser).usingSite(this.testSite).assertThat().containsMessages(new FileModel[]{this.testFile});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor can see files created by self")
    @Test(groups={"protocols", "imap", "core"})
    public void contributorCanViewFileCreatedBySelf() throws Exception {
        UserModel contributorUser = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(contributorUser, this.testSite, UserRole.SiteContributor);
        this.testFile = ((DataContent)this.dataContent.usingUser(contributorUser).usingSite(this.testSite)).createContent(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN));
        this.imapProtocol.authenticateUser(contributorUser).usingSite(this.testSite).assertThat().containsMessages(new FileModel[]{this.testFile});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify file created with spaces in the name is displayed in IMAP client")
    @Test(groups={"protocols", "imap", "core"})
    public void fileWithSpacesInNameIsDisplayedInImap() throws Exception {
        this.testFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(new FileModel("name with spaces.txt", FileType.TEXT_PLAIN));
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).assertThat().containsMessages(new FileModel[]{this.testFile});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that a file created with name which contains special characters is visible in IMAP")
    @Test(groups={"protocols", "imap", "full"})
    public void userCanViewFileWithSpecialCharactersInNameViaIMAP() throws Exception {
        this.testFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(new FileModel("(a)[b]!#%^.txt", FileType.TEXT_PLAIN));
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).assertThat().containsMessages(new FileModel[]{this.testFile}).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that a file created with name which contains symbols is visible in IMAP")
    @Test(groups={"protocols", "imap", "full"})
    public void userCanViewFileWithSymbolsInNameViaIMAP() throws Exception {
        this.testFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(new FileModel("a\u00a3\u00a5\u20ac$\u264a\u264e\u264f\u2650\u2651\u2652\u2653\u03a9.txt", FileType.TEXT_PLAIN));
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).assertThat().containsMessages(new FileModel[]{this.testFile}).usingResource((ContentModel)this.testFile).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can see links via IMAP")
    @Test(groups={"protocols", "imap", "full"})
    public void siteManagerCanViewLinks() throws Exception {
        ((DataLink)((DataLink)this.dataLink.usingUser(this.testUser)).usingSite(this.testSite)).createRandomLink();
        this.imapProtocol.authenticateUser(this.testUser).usingSiteLinksContainer(this.testSite).assertThat().countMessagesIs(1);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can see calendar events via IMAP")
    @Test(groups={"protocols", "imap", "full"})
    public void siteManagerCanViewCalendarEvents() throws Exception {
        ((DataCalendarEvent)((DataCalendarEvent)this.dataCalendarEvent.usingUser(this.testUser)).usingSite(this.testSite)).createRandomCalendarEvent();
        this.imapProtocol.authenticateUser(this.testUser).usingSiteCalendarContainer(this.testSite).assertThat().countMessagesIs(1);
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot read file via IMAP if it is already deleted from repository")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={MessagingException.class}, expectedExceptionsMessageRegExp="No message with subject .* has been found")
    public void siteManagerCannotReadFileInImapIfItWasDeletedFromRepository() throws Exception {
        this.testFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(new FileModel(RandomData.getRandomName((String)"File"), FileType.TEXT_PLAIN));
        ((DataContent)((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFile)).deleteContent();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFile).assertThat().fileContentIsDisplayed();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot read file via IMAP client if it is locked by an user in repository")
    @Test(groups={"protocols", "imap", "full"}, expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp="No content")
    public void siteManagerCannotReadFileInImapIfItsLocked() throws Exception {
        String content = RandomData.getRandomAlphanumeric();
        this.testFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(new FileModel(RandomData.getRandomName((String)"File"), FileType.TEXT_PLAIN, content));
        ((DataContent)((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).usingResource((ContentModel)this.testFile)).checkOutDocument();
        this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFile).assertThat().fileContentIsDisplayed();
    }
}

