/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.Test;

public class ImapMoveMessagesTests
extends EmailTest {
    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify site manager can move message via IMAP client to a different location")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldMoveNonEmptyFile() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
        FileModel fileModel = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)fileModel).assertThat().existsInRepo()).and()).assertThat().existsInImap().then()).moveMessageTo((ContentModel)this.testFolder).assertThat().containsMessages(new FileModel[]{fileModel}).and()).usingSite(this.testSite).assertThat().doesNotContainMessages(new FileModel[]{fileModel});
    }
}

