/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import jakarta.mail.Flags;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.Test;

public class ImapMessageFlagsTests
extends EmailTest {
    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify site manager can set flags action to a content(message) through IMAP Client")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldSetFlagsToAContent() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        FileModel fileModel = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingResource((ContentModel)fileModel).assertThat().existsInRepo()).and()).assertThat().existsInImap().and()).withMessage().setAnsweredFlag().setSeenFlag().updateFlags().then()).assertThat().messageContainsFlags(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.SEEN});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can set flags to a content(message) through IMAP Client")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerShouldSetFlagsToContent() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        FileModel fileModel = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingResource((ContentModel)fileModel).assertThat().existsInRepo()).and()).assertThat().existsInImap().and()).withMessage().setFlags(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.SEEN}).updateFlags().then()).assertThat().messageContainsFlags(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.SEEN});
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can remove flags from a content(message) through IMAP Client")
    @Test(groups={"protocols", "imap", "core"})
    public void siteManagerShouldRemoveFlagsFromContent() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
        FileModel fileModel = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingResource((ContentModel)fileModel).assertThat().existsInRepo()).and()).assertThat().existsInImap().and()).withMessage().setFlags(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.SEEN}).updateFlags().and()).assertThat().messageContainsFlags(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.SEEN}).and()).withMessage().removeFlags(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.SEEN}).updateFlags().then()).assertThat().messageDoesNotContainFlags(new Flags.Flag[]{Flags.Flag.ANSWERED, Flags.Flag.SEEN});
    }
}

