/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.imap;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.email.EmailTest;
import org.alfresco.email.ImapWrapper;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ImapRenameMessagesTests
extends EmailTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createIMAPSite();
    }

    @TestRail(section={"protocols", "imap"}, executionType={ExecutionType.SANITY}, description="Verify the renamed file from repository is still preset in IMAP client with the old name for site manager")
    @Test(groups={"protocols", "imap", "sanity"})
    public void siteManagerShouldVerifyFileContentForRenamedFileViaImap() throws Exception {
        FileModel renamedFile = this.testFile = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        renamedFile.setName(FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN).getName());
        ((ImapWrapper)((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser).usingSite(this.testSite).usingResource((ContentModel)this.testFile).assertThat().existsInRepo()).and()).assertThat().existsInImap().then()).renameMessageTo((ContentModel)renamedFile).assertThat().messageContentMatchesFileModelData(this.testFile);
    }
}

