/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tas.integration;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.util.HashMap;
import javax.json.JsonObject;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestHtmlResponse;
import org.alfresco.tas.integration.IntegrationTest;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.codec.binary.Base64;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class IntegrationWithAosTests
extends IntegrationTest {
    @Bug(id="REPO-2096", status=Bug.Status.FIXED)
    @Test(groups={"integration", "aos", "full", "sso"})
    @TestRail(section={"integration", "aos"}, executionType={ExecutionType.REGRESSION}, description="Security check for AOS Protocol with External Authentification - MNT-17474")
    public void aosCSRFVulnerabilityInSSOEnvironment() throws Exception {
        Step.STEP((String)"1. Post call using RestAPI for specific AOS Security issue");
        UserModel adminUser = this.dataUser.getAdminUser();
        HashMap<String, String> headers = new HashMap<String, String>();
        String authCookie = String.format("%s:%s", adminUser.getUsername(), adminUser.getPassword());
        String authCookieEncoded = new String(Base64.encodeBase64((byte[])authCookie.getBytes()));
        headers.put("Authorization", String.format("Basic %s", authCookieEncoded));
        this.restAPI.configureRequestSpec().addHeaders(headers);
        JsonObject postBody = JsonBodyGenerator.defineJSON().add("method", "create url-directories:6.0.2.8164").add("urldirs", "[[url=ExploitedMNT17474;meta_info=[]]]").build();
        this.restAPI.authenticateUser(adminUser).usingContentType(ContentType.URLENC).withAosAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)postBody.toString(), (String)"_vti_bin/_vti_aut/author.dll", (String[])new String[0]);
        this.restAPI.process(request);
        this.restAPI.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Bug(id="REPO-2172", status=Bug.Status.FIXED)
    @Test(groups={"integration", "aos", "full", "sso"})
    @TestRail(section={"integration", "aos"}, executionType={ExecutionType.REGRESSION}, description="Non domain user can login to aos through Kerberos successfully.")
    public void nonDomainKerberosUserCanLoginSuccessfulInAos() throws Exception {
        Step.STEP((String)"1. Perform a GET request of aos using a non-domain kerberos user");
        String webDavUrl = "alfresco/aos";
        RestAssured.basePath = "";
        this.restAPI.configureRequestSpec().setBasePath(RestAssured.basePath);
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)webDavUrl, (String[])new String[0]);
        RestHtmlResponse response = this.restAPI.authenticateUser(this.dataUser.getAdminUser()).processHtmlResponse(request);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        response.assertPathInHtmlBodyEquals("html.body.table.tr[1].td[0].text()", "Shared");
        response.assertPathInHtmlBodyEquals("html.body.table.tr[2].td[0].text()", "Imap Attachments");
    }

    @Bug(id="REPO-2172", status=Bug.Status.FIXED)
    @Test(groups={"integration", "webdav", "full", "sso"})
    @TestRail(section={"integration", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Non domain user can login to webdav through Kerberos successfully.")
    public void nonDomainKerberosUserCanLoginSuccessfulInWebDav() throws Exception {
        Step.STEP((String)"1. Perform a GET request of webdav using a non-domain kerberos user");
        String webDavUrl = "alfresco/webdav";
        RestAssured.basePath = "";
        this.restAPI.configureRequestSpec().setBasePath(RestAssured.basePath);
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)webDavUrl, (String[])new String[0]);
        RestHtmlResponse response = this.restAPI.authenticateUser(this.dataUser.getAdminUser()).processHtmlResponse(request);
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        response.assertPathInHtmlBodyEquals("html.body.table.tr.td[0].text()", "Directory listing for /");
        response.assertPathInHtmlBodyEquals("html.body.table.tr.td.find{it.@class=='textData'}[0].text()", "Shared");
    }
}

