/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tas.integration;

import jakarta.mail.MessagingException;
import java.util.ArrayList;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.email.ImapWrapper;
import org.alfresco.ftp.FTPWrapper;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.tas.integration.IntegrationTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavWrapper;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IntegrationSanityTests
extends IntegrationTest {
    UserModel testUser1;
    UserModel testUser2;
    UserModel testUser3;
    SiteModel testSitePublic;
    SiteModel testSiteModerated;
    SiteModel testSitePrivate;
    SiteModel secondTestSitePublic;
    FolderModel testFolder1;
    FolderModel testFolder2;
    FolderModel testFolder3;
    FileModel testFile1;
    FileModel testFile2;
    FileModel testFile3;
    FileModel testFile4;
    RestCommentModel comment;

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "content", "comments"}, executionType={ExecutionType.SANITY}, description="Verify two new users are able to manage comments on the same file.")
    public void usersAreAbleToManageComments() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two test users: u1, u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. Using REST API add u2 as member with Collaborator role");
        this.testUser2.setUserRole(UserRole.SiteCollaborator);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.testSitePublic).addPerson(this.testUser2);
        Step.STEP((String)"* 4. U2 creates one folder F1 using WEBDAV");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser2).usingSite(this.testSitePublic).createFolder(this.testFolder1).and()).assertThat().existsInWebdav();
        Step.STEP((String)"* 5. U2 creates one file in F1 using WebDAV");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFolder1).createFile(this.testFile1).and()).assertThat().existsInWebdav();
        Step.STEP((String)"* 6. U2 adds a comment to file using REST API");
        this.comment = this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile1).addComment("U2 comment");
        this.restAPI.assertStatusCodeIs(HttpStatus.CREATED);
        this.comment.assertThat().field("content").is((Object)"U2 comment");
        Step.STEP((String)"* 7. U1 gets comments using REST API");
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)this.testFile1).getNodeComments().assertThat().entriesListContains("content", "U2 comment");
        Step.STEP((String)"* 8. U1 updates the file content using WEBDAV. Assert with CMIS that content is updated");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).update("file content");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).assertThat().contentIs("file content");
        Step.STEP((String)"* 9. U1 updates comment using REST API");
        this.comment = this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile1).updateComment(this.comment, "U1 updated comment");
        this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        this.comment.assertThat().field("content").is((Object)"U1 updated comment");
        Step.STEP((String)"* 10. U2 gets comments using REST API");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingResource((RepoTestModel)this.testFile1).getNodeComments().assertThat().entriesListContains("content", "U1 updated comment");
        Step.STEP((String)"* 11. U2 deletes comment using REST API");
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile1).deleteComment(this.comment);
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"* 12. U1 deletes file using FTP. Assert with CMIS that file doesn't exist in repository");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).delete().assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify two new users are able to manage favorites.")
    public void usersAreAbleToManageFavorites() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two test users: u1, u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.restAPI.authenticateUser(this.dataUser.getAdminUser());
        Step.STEP((String)"* 3. Using CMIS add u2 as site member with Contributor role");
        ((DataUser)this.dataUser.usingUser(this.testUser1)).addUserToSite(this.testUser2, this.testSitePublic, UserRole.SiteContributor);
        Step.STEP((String)"* 4. U1 creates one folder F1 using FTP");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).and()).assertThat().existsInRepo();
        Step.STEP((String)"* 5. U1 creates one file in F1 using WEBDAV");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(this.testFile1).and()).assertThat().existsInWebdav();
        Step.STEP((String)"* 6. U2 adds file to favorites using REST API");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addFileToFavorites(this.testFile1).assertThat().field("targetGuid").is((Object)this.testFile1.getNodeRef().replace(";1.0", ""));
        Step.STEP((String)"* 7. U2 gets favorites using REST API. Assert that only the file is favorite.");
        ((RestModels)this.restAPI.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListContains("targetGuid", this.testFile1.getNodeRef().replace(";1.0", ""))).and().paginationField("totalItems").is("1");
        Step.STEP((String)"* 8. U1 gets favorites using REST API. Assert that U1 has his site at favorites.");
        ((RestModels)this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListContains("targetGuid", this.testSitePublic.getGuid())).and().paginationField("totalItems").is("1");
        Step.STEP((String)"* 9. U1 adds file to favorites using REST API");
        this.restAPI.withCoreAPI().usingAuthUser().addFileToFavorites(this.testFile1).assertThat().field("targetGuid").is((Object)this.testFile1.getNodeRef().replace(";1.0", ""));
        Step.STEP((String)"* 10. U1 adds folder to favorites using REST API");
        this.restAPI.withCoreAPI().usingAuthUser().addFolderToFavorites(this.testFolder1).assertThat().field("targetGuid").is((Object)this.testFolder1.getNodeRef());
        Step.STEP((String)"* 11. U2 remove file from favorites using REST API");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().deleteFileFromFavorites(this.testFile1);
        Step.STEP((String)"* 12. U2 adds site to favorites using REST API");
        this.restAPI.withCoreAPI().usingAuthUser().addSiteToFavorites(this.testSitePublic).assertThat().field("targetGuid").is((Object)this.testSitePublic.getGuid());
        Step.STEP((String)"* 13. U2 gets favorites using REST API. Assert that only site is favorite.");
        ((RestModels)((RestModels)this.restAPI.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.testFile1.getNodeRef().replace(";1.0", ""))).and().entriesListContains("targetGuid", this.testSitePublic.getGuid())).and().paginationField("totalItems").is("1");
        Step.STEP((String)"* 14. U1 gets favorites using REST API. Assert that site, file and folder are favorites.");
        ((RestModels)((RestModels)((RestModels)this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListContains("targetGuid", this.testSitePublic.getGuid())).assertThat().entriesListContains("targetGuid", this.testFile1.getNodeRef().replace(";1.0", ""))).and().entriesListContains("targetGuid", this.testFolder1.getNodeRef())).and().paginationField("totalItems").is("3");
        Step.STEP((String)"* 15. U1 deletes file using WebDAV. Assert with WebDAV that file doesn't exist in repository");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).delete().and()).assertThat().doesNotExistInWebdav();
        Step.STEP((String)"* 16. U1 gets favorites using REST API. Assert that only site and folder are favorites.");
        ((RestModels)((RestModels)this.restAPI.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListContains("targetGuid", this.testSitePublic.getGuid())).assertThat().entriesListContains("targetGuid", this.testFolder1.getNodeRef())).and().paginationField("totalItems").is("2");
        Step.STEP((String)"* 17. U2 gets favorites using REST API. Assert that only site is favorite.");
        ((RestModels)this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListContains("targetGuid", this.testSitePublic.getGuid())).and().paginationField("totalItems").is("1");
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.SANITY}, description="Verify user is able to manage files and folders.")
    public void userIsAbleToManageFilesAndFolders() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two test users: u1, u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createIMAPSite();
        Step.STEP((String)"* 3. Using CMIS add u2 as site member with Manager role");
        ((DataUser)this.dataUser.usingUser(this.testUser1)).addUserToSite(this.testUser2, this.testSitePublic, UserRole.SiteManager);
        Step.STEP((String)"* 4. U1 creates 3 folders: F1 using FTP, F2 using WebDAV as a subfolder of F1, F3 using WEBDAV as a subfolder of F2. * 5. U1 creates one file in each folder using FTP and WEBDAV");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.testFolder2 = FolderModel.getRandomFolderModel();
        this.testFolder3 = FolderModel.getRandomFolderModel();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.HTML);
        this.testFile3 = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"some content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).and()).assertThat().existsInFtp();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFolder(this.testFolder2).assertThat().existsInWebdav().and()).createFile(this.testFile1).assertThat().existsInWebdav();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder2).createFolder(this.testFolder3).assertThat().existsInWebdav().and()).createFile(this.testFile2).assertThat().existsInWebdav();
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder3).createFile(this.testFile3).then()).assertThat().existsInFtp();
        Step.STEP((String)" * 6. U1 renames F2 using IMAP");
        ((ImapWrapper)((ImapWrapper)this.imapProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder2).rename("F2 rename").then()).usingResource((ContentModel)this.testFolder1).assertThat().contains(new FolderModel[]{new FolderModel("F2 rename")}).and()).assertThat().doesNotContain(new FolderModel[]{this.testFolder2});
        Step.STEP((String)" * 7. U1 updates file1 using WebDAV");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).update("testFile1 content.").then()).assertThat().contentIs("testFile1 content.");
        Step.STEP((String)"* 8. U1 deletes file2 using FTP");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile2).delete().then()).assertThat().doesNotExistInRepo();
        Step.STEP((String)" * 9. U1 deletes non empty folder3 using WEBDAV");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder3).delete().then()).assertThat().doesNotExistInWebdav();
        Step.STEP((String)"* 10. Assert with CMIS that U2 is able to see all the above changes");
        this.cmisAPI.authenticateUser(this.testUser2).usingResource((ContentModel)this.testFolder1).assertThat().hasChildren(new ContentModel[]{this.testFile1}).usingResource((ContentModel)this.testFile1).assertThat().contentIs("testFile1 content.").usingResource((ContentModel)this.testFile2).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFolder3).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile3).assertThat().doesNotExistInRepo();
        FolderModel renamedFolder = (FolderModel)this.cmisAPI.usingResource((ContentModel)this.testFolder1).getFolders().get(0);
        Assert.assertEquals((String)renamedFolder.getName(), (String)"F2 rename", (String)"User2 is able to see the renamed folder");
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "content", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify two new users are able to manage favorite files.")
    public void usersAreAbleToManageFavoriteFiles() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two test users: u1, u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.restAPI.authenticateUser(this.dataUser.getAdminUser());
        this.testSitePublic.setGuid(this.restAPI.withCoreAPI().usingSite(this.testSitePublic).getSite().getGuid());
        Step.STEP((String)"* 3. Using REST API add u2 as site member with Collaborator role");
        this.testUser2.setUserRole(UserRole.SiteCollaborator);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.testSitePublic).addPerson(this.testUser2);
        Step.STEP((String)" * 4. U2 creates file1 with using CMIS");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser2).usingSite(this.testSitePublic).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 5. U1 creates file2 from source using CMIS");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        ((CmisWrapper)((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFileFromSource(this.testFile2, (ContentModel)this.testFile1).and()).refreshResource().then()).assertThat().existsInRepo();
        Step.STEP((String)" * 6. U1 uploads file3 using FTP");
        this.testFile3 = FileModel.getFileModelBasedOnTestDataFile((String)"testUploadFile.txt");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile3).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 7. U1 creates file4 using CMIS");
        this.testFile4 = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"file4 content");
        ((CmisWrapper)this.cmisAPI.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile4).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 8. U1 marks file1 and 3 as favorite using REST API");
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().addFileToFavorites(this.testFile1).assertThat().field("targetGuid").is((Object)this.testFile1.getNodeRef().replace(";1.0", ""));
        this.restAPI.withCoreAPI().usingAuthUser().addFileToFavorites(this.testFile3).assertThat().field("targetGuid").is((Object)this.testFile3.getNodeRef().replace(";1.0", ""));
        Step.STEP((String)"* 9. U2 marks file 1, 2, 4 as favorite using REST API");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addFileToFavorites(this.testFile1).assertThat().field("targetGuid").is((Object)this.testFile1.getNodeRef().replace(";1.0", ""));
        this.restAPI.withCoreAPI().usingAuthUser().addFileToFavorites(this.testFile2).assertThat().field("targetGuid").is((Object)this.testFile2.getNodeRef().replace(";1.0", ""));
        this.restAPI.withCoreAPI().usingAuthUser().addFileToFavorites(this.testFile4).assertThat().field("targetGuid").is((Object)this.testFile4.getNodeRef().replace(";1.0", ""));
        Step.STEP((String)"* 10. U2 marks site as favorite using REST API");
        this.restAPI.withCoreAPI().usingAuthUser().addSiteToFavorites(this.testSitePublic).assertThat().field("targetGuid").is((Object)this.testSitePublic.getGuid());
        Step.STEP((String)"* 11. U1 removes file1 from favorites using REST API");
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().deleteFileFromFavorites(this.testFile1);
        Step.STEP((String)"* 12. U2 checks file favorites using REST API. Assert that U2 gets only his favorite files.");
        ((RestModels)((RestModels)((RestModels)this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().where().targetFileExist().getFavorites().assertThat().entriesListContains("targetGuid", this.testFile1.getNodeRef().replace(";1.0", ""))).and().entriesListContains("targetGuid", this.testFile2.getNodeRef().replace(";1.0", ""))).and().entriesListContains("targetGuid", this.testFile4.getNodeRef().replace(";1.0", ""))).and().paginationField("totalItems").is("3");
        Step.STEP((String)"* 13. U2 removes file1 from favorites using REST API");
        this.restAPI.withCoreAPI().usingAuthUser().deleteFileFromFavorites(this.testFile1);
        Step.STEP((String)"* 14. U2 checks file favorites using REST API. Assert that U2 gets only his favorite files.");
        ((RestModels)((RestModels)this.restAPI.withCoreAPI().usingAuthUser().where().targetFileExist().getFavorites().assertThat().entriesListContains("targetGuid", this.testFile2.getNodeRef().replace(";1.0", ""))).and().entriesListContains("targetGuid", this.testFile4.getNodeRef().replace(";1.0", ""))).and().paginationField("totalItems").is("2");
    }

    @Bug(id="REPO-4789")
    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "content", "tags"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to manage tags.")
    public void siteManagerIsAbleToManageTags() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create a test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 creates 2 files in site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.testFile2 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file2 content");
        ((FTPWrapper)((FTPWrapper)((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile1).then()).assertThat().existsInRepo()).createFile(this.testFile2).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 creates folder1 in site's document library using WebDAV");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 5. U1 creates another 2 files in folder1 using WEBDAV");
        this.testFile3 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file3 content");
        this.testFile4 = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)"file4 content");
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).createFile(this.testFile3).then()).assertThat().existsInRepo()).createFile(this.testFile4).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 6. U1 adds tag1, tag2 on file1, tag2 on file2 using REST API");
        ((RestModels)this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingResource((RepoTestModel)this.testFile1).addTags(new String[]{"integration_tag1", "integration_tag2"}).assertThat().entriesListContains("tag", "integration_tag1")).and().entriesListContains("tag", "integration_tag2");
        RestTagModel tag2 = (RestTagModel)this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile2).addTag("integration_tag2").assertThat().field("tag").is((Object)"integration_tag2");
        Step.STEP((String)"* 7. U1 adds tag1 on folder1, tag3 on file3 using REST API");
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFolder1).addTag("integration_tag1").assertThat().field("tag").is((Object)"integration_tag1");
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile3).addTag("integration_tag3").assertThat().field("tag").is((Object)"integration_tag3");
        Step.STEP((String)"* 8. U1 gets tags and verify all tags are listed");
        Utility.sleep((int)500, (int)30000, () -> ((RestModels)((RestModels)this.restAPI.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags().assertThat().entriesListContains("tag", "integration_tag1")).and().entriesListContains("tag", "integration_tag2")).and().entriesListContains("tag", "integration_tag3"));
        Step.STEP((String)"* 9. U1 gets file1 tags and verify only tag1 and tag2 are listed");
        ((RestModels)((RestModels)this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile1).getNodeTags().assertThat().entriesListContains("tag", "integration_tag1")).and().entriesListContains("tag", "integration_tag2")).and().paginationField("totalItems").is("2");
        Step.STEP((String)"* 10. U1 deletes tag2 from file1");
        this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile1).deleteTag(tag2);
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"* 11. U1 deletes file3 using WebDAV");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile3).delete().then()).assertThat().doesNotExistInWebdav();
        Step.STEP((String)"* 12. U1 gets tags and verify all tags are listed");
        ((RestModels)((RestModels)this.restAPI.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags().assertThat().entriesListContains("tag", "integration_tag1")).and().entriesListContains("tag", "integration_tag2")).and().entriesListContains("tag", "integration_tag3");
        Step.STEP((String)" * 13. U1 gets file1 tags and verify tag2 was removed.");
        ((RestModels)((RestModels)this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFile1).getNodeTags().assertThat().entriesListContains("tag", "integration_tag1")).and().entriesListDoesNotContain("tag", "integration_tag2")).and().paginationField("totalItems").is("1");
        Step.STEP((String)"* 14. U1 gets folder1 tags and verify only tag1 is listed.");
        ((RestModels)this.restAPI.withCoreAPI().usingResource((RepoTestModel)this.testFolder1).getNodeTags().assertThat().entriesListContains("tag", "integration_tag1")).and().paginationField("totalItems").is("1");
        Step.STEP((String)"* 15. U1 deletes non empty folder1 using CMIS");
        this.cmisAPI.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).deleteFolderTree().assertThat().doesNotExistInRepo();
        Step.STEP((String)"* 16. U1 gets tags and verify all tags are listed");
        ((RestModels)((RestModels)this.restAPI.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags().assertThat().entriesListContains("tag", "integration_tag1")).and().entriesListContains("tag", "integration_tag2")).and().entriesListContains("tag", "integration_tag3");
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "sites"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to manage site membership.")
    public void siteManagerIsAbleToManageSiteMembership() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create 3 test user: u1, u2, u3");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        this.testUser3 = this.dataUser.createRandomTestUser();
        Step.STEP((String)" * 2. Using CMIS U1 creates a public test site, a moderated test site and a private test site");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testSiteModerated = ((DataSite)this.dataSite.usingUser(this.testUser1)).createModeratedRandomSite();
        this.testSitePrivate = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPrivateRandomSite();
        Step.STEP((String)"* 3. Using REST API, U2 request to join the public site");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.testSitePublic);
        Step.STEP((String)"* 4. Using REST API, U3 request to join the public site");
        this.restAPI.authenticateUser(this.testUser3).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.testSitePublic);
        Step.STEP((String)" * 5. Using REST API, check that u2 and u3 are added to public site with Consumer role");
        ((RestModels)this.restAPI.withCoreAPI().usingSite(this.testSitePublic).getSiteMembers().assertThat().entriesListContains("id", this.testUser2.getUsername())).and().entriesListContains("id", this.testUser3.getUsername());
        this.restAPI.withCoreAPI().usingSite(this.testSitePublic).getSiteMember(this.testUser2).assertThat().field("role").is((Object)"SiteConsumer");
        this.restAPI.withCoreAPI().usingSite(this.testSitePublic).getSiteMember(this.testUser3).assertThat().field("role").is((Object)"SiteConsumer");
        Step.STEP((String)"* 6. Using REST API, U3 request to join the moderated site");
        this.restAPI.withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.testSiteModerated);
        Step.STEP((String)"* 7. Using REST API, U2 request to join the moderated site");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.testSiteModerated);
        Step.STEP((String)"* 8. Using REST API, check that u2 and u3 requests to join the moderated site are added to site membership request list");
        ((RestModels)this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.testSiteModerated).getSiteMembers().assertThat().entriesListDoesNotContain("id", this.testUser2.getUsername())).and().entriesListDoesNotContain("id", this.testUser3.getUsername());
        this.restAPI.withCoreAPI().usingUser(this.testUser2).getSiteMembershipRequest(this.testSiteModerated).assertThat().field("id").is((Object)this.testSiteModerated.getId());
        this.restAPI.withCoreAPI().usingUser(this.testUser3).getSiteMembershipRequest(this.testSiteModerated).assertThat().field("id").is((Object)this.testSiteModerated.getId());
        Step.STEP((String)"* 9. Using REST API, U1 cancels the request for U3");
        this.restAPI.withCoreAPI().usingUser(this.testUser3).deleteSiteMembershipRequest(this.testSiteModerated);
        Step.STEP((String)"* 10. Using REST API, check that u2 can't make requests to join the private site.");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.testSitePrivate);
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        Step.STEP((String)"* 11. Using REST API, check that only u2 request remains in site membership request list");
        ((RestModels)this.restAPI.withCoreAPI().usingAuthUser().getSiteMembershipRequests().assertThat().entriesListContains("id", this.testSiteModerated.getId())).and().paginationField("totalItems").is("1");
        this.restAPI.authenticateUser(this.testUser3).withCoreAPI().usingAuthUser().getSiteMembershipRequests().assertThat().entriesListIsEmpty();
        Step.STEP((String)"* 12. Using REST API, U1 change U2 role to Collaborator in public site");
        this.testUser2.setUserRole(UserRole.SiteCollaborator);
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.testSitePublic).updateSiteMember(this.testUser2).assertThat().field("role").is((Object)this.testUser2.getUserRole());
        Step.STEP((String)"* 13. Using REST API, get site membership information for each user");
        this.restAPI.withCoreAPI().usingAuthUser().getSitesMembershipInformation().assertThat().paginationField("count").is("3");
        ((RestModels)((RestModels)this.restAPI.withCoreAPI().usingUser(this.testUser2).getSitesMembershipInformation().assertThat().entriesListContains("id", this.testSitePublic.getId())).and().entriesListContains("role", "SiteCollaborator")).and().paginationField("count").is("1");
        ((RestModels)((RestModels)this.restAPI.withCoreAPI().usingUser(this.testUser3).getSitesMembershipInformation().assertThat().entriesListContains("id", this.testSitePublic.getId())).and().entriesListContains("role", "SiteConsumer")).and().paginationField("count").is("1");
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "sites", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify users are able to manage favorite sites.")
    public void userIsAbleToManageFavoriteSites() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create a test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. Using CMIS U1 creates a public site, a moderated test site and a private test site");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testSiteModerated = ((DataSite)this.dataSite.usingUser(this.testUser1)).createModeratedRandomSite();
        this.testSitePrivate = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPrivateRandomSite();
        Step.STEP((String)"* 3. Using WEBDAV, U1 adds file1 to site1");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"* 4. Using REST API, check the u1 favorites sites list");
        ((RestModels)((RestModels)((RestModels)this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites().assertThat().entriesListContains("targetGuid", this.testSitePublic.getGuid())).and().entriesListContains("targetGuid", this.testSiteModerated.getGuid())).and().entriesListContains("targetGuid", this.testSitePrivate.getGuid())).and().paginationField("totalItems").is("3");
        Step.STEP((String)"* 5. Using REST API, U1 removes site1 from favorites");
        this.restAPI.withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.testSitePublic);
        Step.STEP((String)"* 6. Using REST API, check the u1 favorites sites list");
        ((RestModels)((RestModels)this.restAPI.withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites().assertThat().entriesListContains("targetGuid", this.testSiteModerated.getGuid())).and().entriesListContains("targetGuid", this.testSitePrivate.getGuid())).and().paginationField("totalItems").is("2");
        Step.STEP((String)"* 7. Using CMIS, U1 deletes site2");
        ((DataSite)this.dataSite.usingUser(this.testUser1)).deleteSite(this.testSiteModerated);
        Step.STEP((String)"* 8. Using REST API, check the u1 favorites sites list");
        ((RestModels)this.restAPI.withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites().assertThat().entriesListContains("targetGuid", this.testSitePrivate.getGuid())).and().paginationField("totalItems").is("1");
        Step.STEP((String)"* 9. Using REST API, U1 marks site1 as favorite");
        this.restAPI.withCoreAPI().usingAuthUser().addSiteToFavorites(this.testSitePublic).assertThat().field("targetGuid").is((Object)this.testSitePublic.getGuid());
        Step.STEP((String)"* 10. Using REST API, check the u1 favorites sites list");
        ((RestModels)((RestModels)this.restAPI.withCoreAPI().usingAuthUser().where().targetSiteExist().getFavorites().assertThat().entriesListContains("targetGuid", this.testSitePublic.getGuid())).and().entriesListContains("targetGuid", this.testSitePrivate.getGuid())).and().paginationField("totalItems").is("2");
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "sites"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to cancel requests to join moderated site.")
    public void siteManagerIsAbleToCancelSiteMembership() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create 3 test user: u1, u2, u3");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        this.testUser3 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. Using CMIS U1 creates a a moderated test site");
        this.testSiteModerated = ((DataSite)this.dataSite.usingUser(this.testUser1)).createModeratedRandomSite();
        Step.STEP((String)"* 3. Using REST API, U2 request to join the moderated site");
        this.restAPI.authenticateUser(this.testUser2).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.testSiteModerated);
        Step.STEP((String)"* 4. Using REST API, U3 request to join the moderated site");
        this.restAPI.authenticateUser(this.testUser3).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.testSiteModerated);
        Step.STEP((String)"* 5. Using REST API, check that u2 and u3 requests to join the moderated site are added to site membership request list");
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingUser(this.testUser2).getSiteMembershipRequest(this.testSiteModerated).assertThat().field("id").is((Object)this.testSiteModerated.getId());
        this.restAPI.withCoreAPI().usingUser(this.testUser3).getSiteMembershipRequest(this.testSiteModerated).assertThat().field("id").is((Object)this.testSiteModerated.getId());
        Step.STEP((String)"* 6. Using REST API, U1 cancels the request for U3");
        this.restAPI.withCoreAPI().usingUser(this.testUser3).deleteSiteMembershipRequest(this.testSiteModerated);
        Step.STEP((String)"* 7. Using REST API, check that u3 request isn't in site membership request list");
        this.restAPI.withCoreAPI().usingUser(this.testUser3).getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "The relationship resource")).containsSummary(this.testUser3.getUsername());
        Step.STEP((String)"* 8. Using REST API, U1 cancels the request for U2");
        this.restAPI.withCoreAPI().usingUser(this.testUser2).deleteSiteMembershipRequest(this.testSiteModerated);
        Step.STEP((String)"* 9. Using REST API, check that u2 request isn't in site membership request list.");
        this.restAPI.withCoreAPI().usingUser(this.testUser2).getSiteMembershipRequest(this.testSiteModerated);
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "The relationship resource")).containsSummary(this.testUser2.getUsername());
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user is able to get site membership informations.")
    public void userIsAbleToGetSiteMembershipInfo() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create 2 test user: u1, u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. Using CMIS U1 creates 3 test sites");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testSiteModerated = ((DataSite)this.dataSite.usingUser(this.testUser1)).createModeratedRandomSite();
        this.testSitePrivate = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPrivateRandomSite();
        Step.STEP((String)"* 3. Using CMIS U1 adds U2 to site1 with \"Consumer\" role");
        ((DataUser)this.dataUser.usingUser(this.testUser1)).addUserToSite(this.testUser2, this.testSitePublic, UserRole.SiteConsumer);
        Step.STEP((String)"* 4. Using CMIS U1 adds U2 to site2 with \"Collaborator\" role");
        ((DataUser)this.dataUser.usingUser(this.testUser1)).addUserToSite(this.testUser2, this.testSiteModerated, UserRole.SiteCollaborator);
        Step.STEP((String)"* 5. Using REST API, admin adds U2 to site3 with \"Manager\" role");
        this.testUser2.setUserRole(UserRole.SiteManager);
        this.restAPI.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(this.testSitePrivate).addPerson(this.testUser2);
        Step.STEP((String)"* 6. Using REST API, verify that site1, site2, site3 are present in the list of sites for U2");
        ((RestModels)((RestModels)((RestModels)this.restAPI.withCoreAPI().usingUser(this.testUser2).getSitesMembershipInformation().assertThat().entriesListContains("id", this.testSitePublic.getId())).and().entriesListContains("id", this.testSiteModerated.getId())).and().entriesListContains("id", this.testSitePrivate.getId())).and().paginationField("count").is("3");
        this.restAPI.withCoreAPI().usingSite(this.testSitePublic).getSiteMember(this.testUser2).assertThat().field("role").is((Object)"SiteConsumer");
        this.restAPI.withCoreAPI().usingSite(this.testSiteModerated).getSiteMember(this.testUser2).assertThat().field("role").is((Object)"SiteCollaborator");
        this.restAPI.withCoreAPI().usingSite(this.testSitePrivate).getSiteMember(this.testUser2).assertThat().field("role").is((Object)"SiteManager");
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.SANITY}, description="Verify user is able to copy file to a folder from another site.")
    public void userIsAbleToCopyFileToAFolderFromAnotherSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create a test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in site's document library using WebDAV");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 creates another site using CMIS");
        this.secondTestSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 5. U1 creates a folder in second site's document library using FTP");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.secondTestSitePublic).createFolder(this.testFolder1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 6. U1 copy file to folder using WEBDAV");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).copyTo((ContentModel)this.testFolder1).assertThat().existsInRepo();
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.SANITY}, description="Verify user is able to move file to a folder from another site.")
    public void userIsAbleToMoveFileToAFolderFromAnotherSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create a test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U1 creates another site using CMIS");
        this.secondTestSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 5. U1 creates a folder in second site's document library using WebDAV");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.secondTestSitePublic).createFolder(this.testFolder1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 6. U1 moves file to folder using FTP");
        this.ftpProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).moveTo((ContentModel)this.testFolder1).assertThat().existsInRepo();
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user is able to get created sites with different visibility.")
    public void userIsAbleToGetSitesWithDifferentVisibility() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create a test user: u1");
        this.testUser1 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a public test site, a moderated test site and a private test site using CMIS ");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testSiteModerated = ((DataSite)this.dataSite.usingUser(this.testUser1)).createModeratedRandomSite();
        this.testSitePrivate = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPrivateRandomSite();
        Step.STEP((String)"* 3. U1 gets each site with REST API: public, moderated and private sites are listed");
        this.restAPI.authenticateUser(this.testUser1);
        ArrayList<SiteModel> createdSites = new ArrayList<SiteModel>();
        createdSites.add(this.testSitePublic);
        createdSites.add(this.testSiteModerated);
        createdSites.add(this.testSitePrivate);
        for (SiteModel site : createdSites) {
            ((RestSiteModel)this.restAPI.withCoreAPI().usingSite(site).getSite().assertThat().field("id").is((Object)site.getId())).and().field("title").is((Object)site.getTitle());
            this.restAPI.assertStatusCodeIs(HttpStatus.OK);
        }
        Step.STEP((String)"* 4. U1 deletes moderated site using CMIS");
        ((DataSite)this.dataSite.usingUser(this.testUser1)).deleteSite(this.testSiteModerated);
        Step.STEP((String)"* 5. U1 gets each site with REST API: public and private sites are listed");
        ((RestModels)((RestModels)this.restAPI.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getSites().assertThat().entriesListContains("id", this.testSitePublic.getId())).assertThat().entriesListContains("id", this.testSitePrivate.getId())).assertThat().entriesListDoesNotContain("id", this.testSiteModerated.getId());
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.SANITY}, description="Verify uninvited user is not able to copy document to a private site.")
    public void userIsNotAbleToCopyAFileToAPrivateSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a public site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 creates a file in public site's document library using FTP");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((FTPWrapper)this.ftpProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U2 creates a private site using CMIS");
        this.testSitePrivate = ((DataSite)this.dataSite.usingUser(this.testUser2)).createPrivateRandomSite();
        Step.STEP((String)"* 5. U2 creates a folder in public site's document library using WebDAV");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser2).usingSite(this.testSitePrivate).createFolder(this.testFolder1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 6. U1 copies the file in private site's document library using WEBDAV* 7. Using WEBDAV, verify that file was not copied");
        this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).copyTo((ContentModel)this.testFolder1).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user is able to get user membership information.")
    public void userIsAbleToGetASiteMember() throws Exception {
        Step.STEP((String)"* 1: Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2: U1 creates a public site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. U1 adds U2 to site with \"Consumer\" role using CMIS");
        ((DataUser)this.dataUser.usingUser(this.testUser1)).addUserToSite(this.testUser2, this.testSitePublic, UserRole.SiteConsumer);
        Step.STEP((String)"* 4. Using REST API, verify membership information for u2 on public site");
        this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.testSitePublic).getSiteMember(this.testUser2).assertThat().field("role").is((Object)"SiteConsumer");
        Step.STEP((String)"* 5. Using REST API, U1 change U2 role to Collaborator in public site");
        this.testUser2.setUserRole(UserRole.SiteCollaborator);
        this.restAPI.withCoreAPI().usingSite(this.testSitePublic).updateSiteMember(this.testUser2).assertThat().field("role").is((Object)this.testUser2.getUserRole());
        Step.STEP((String)"* 6. Using REST API, verify membership information for u2 on public site");
        this.restAPI.withCoreAPI().usingSite(this.testSitePublic).getSiteMember(this.testUser2).assertThat().field("role").is((Object)"SiteCollaborator");
        Step.STEP((String)"* 7. Using REST API, U1 remove U2 from public site");
        this.restAPI.withCoreAPI().usingSite(this.testSitePublic).deleteSiteMember(this.testUser2);
        this.restAPI.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"* 8. Using REST API, verify that u2 isn't member of u1 public site");
        this.restAPI.withCoreAPI().usingSite(this.testSitePublic).getSiteMember(this.testUser2);
        this.restAPI.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format("The relationship resource was not found for the entity with id: %s and a relationship id of %s", this.testUser2.getUsername(), this.testSitePublic.getId()));
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user is able to get site membership informations.")
    public void userIsAbleToGetSite() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create 3 test user: u1, u2, u3");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        this.testUser3 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. Using CMIS U1 creates a public site");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        Step.STEP((String)"* 3. Using CMIS U1 adds U2 to site with \"Contributor\" role");
        ((DataUser)this.dataUser.usingUser(this.testUser1)).addUserToSite(this.testUser2, this.testSitePublic, UserRole.SiteContributor);
        Step.STEP((String)"* 4. Using CMIS U1 adds U3 to site with \"Collaborator\" role");
        ((DataUser)this.dataUser.usingUser(this.testUser1)).addUserToSite(this.testUser3, this.testSitePublic, UserRole.SiteCollaborator);
        Step.STEP((String)"* 5. Using REST API, verify the information related to site's containers and members");
        ((RestSiteModel)this.restAPI.authenticateUser(this.testUser1).withCoreAPI().usingSite(this.testSitePublic).getSite().assertThat().field("visibility").is((Object)"PUBLIC")).and().field("id").is((Object)this.testSitePublic.getId());
        this.restAPI.withCoreAPI().usingSite(this.testSitePublic).getSiteMembers().assertThat().paginationField("count").is("3");
        ((RestModels)this.restAPI.withCoreAPI().usingSite(this.testSitePublic).getSiteContainers().assertThat().entriesListContains("folderId", "documentLibrary")).and().paginationField("totalItems").is("1");
    }

    @Test(groups={"integration", "sanity"})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.SANITY}, description="Verify user is not able to copy folder to a moderated site if it is not a member of that site.")
    public void copyFolderToModeratedSiteByUninvitedUser() throws Exception {
        Step.STEP((String)"* 1. Using CMIS create two users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"* 2. U1 creates a public test site and U2 a moderated test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testSiteModerated = ((DataSite)this.dataSite.usingUser(this.testUser2)).createModeratedRandomSite();
        Step.STEP((String)"* 3. U1 creates a folder with a file in public site's document library using WEBDAV");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFolder(this.testFolder1).assertThat().existsInWebdav().then()).usingResource((ContentModel)this.testFolder1).createFile(this.testFile1).then()).assertThat().existsInRepo();
        Step.STEP((String)"* 4. U2 creates a folder in moderated site's document library using FTP");
        this.testFolder2 = FolderModel.getRandomFolderModel();
        this.ftpProtocol.authenticateUser(this.testUser2).usingSite(this.testSiteModerated).createFolder(this.testFolder2).assertThat().existsInRepo();
        Step.STEP((String)"* 5. U1 tries to copy the folder to moderated site using WebDAV* 6. Verify folder is not copied. U1 is not authorized to access the moderated site");
        this.testFolder2.setProtocolLocation(this.webDavProtocol.getPrefixSpace() + this.testFolder2.getCmisLocation());
        ((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFolder1).copyTo((ContentModel)this.testFolder2).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav();
    }

    @Test(groups={"integration", "sanity"}, expectedExceptions={MessagingException.class})
    @TestRail(section={"integration", "content"}, executionType={ExecutionType.SANITY}, description="Verify user is not able to move file to a private site if he is not a member of that site.")
    public void moveFileToPrivateSiteByUninvitedUser() throws Exception {
        Step.STEP((String)"1. Using CMIS create 2 test users: u1 and u2");
        this.testUser1 = this.dataUser.createRandomTestUser();
        this.testUser2 = this.dataUser.createRandomTestUser();
        Step.STEP((String)"2. U1 creates a public test site and U2 a private test site using CMIS");
        this.testSitePublic = ((DataSite)this.dataSite.usingUser(this.testUser1)).createPublicRandomSite();
        this.testSitePrivate = ((DataSite)this.dataSite.usingUser(this.testUser2)).createPrivateRandomSite();
        Step.STEP((String)"3. U1 creates a file in public site's document library using WEBDAV");
        this.testFile1 = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)"file1 content");
        this.webDavProtocol.authenticateUser(this.testUser1).usingSite(this.testSitePublic).createFile(this.testFile1).assertThat().existsInRepo();
        Step.STEP((String)"4. U2 creates a folder in private site's document library using WebDAV");
        this.testFolder1 = FolderModel.getRandomFolderModel();
        this.webDavProtocol.authenticateUser(this.testUser2).usingSite(this.testSitePrivate).createFolder(this.testFolder1).assertThat().existsInRepo();
        Step.STEP((String)"5. U1 tries to move his file to folder from U2 private site using IMAP. 6. Verify file is not moved. U1 is not authorized to access the private site ");
        this.testFolder1.setProtocolLocation(this.testFolder1.getCmisLocation());
        this.imapProtocol.authenticateUser(this.testUser1).usingResource((ContentModel)this.testFile1).moveMessageTo((ContentModel)this.testFolder1).assertThat().doesNotContainMessages(new FileModel[]{this.testFile1});
    }
}

