/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.actions;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestActionDefinitionModel;
import org.alfresco.rest.model.RestActionDefinitionModelsCollection;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ActionsTests
extends RestTest {
    private UserModel adminUser;
    private FileModel document;
    private SiteModel publicSite;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.publicSite = this.dataSite.createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingUser(this.adminUser).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @TestRail(section={"rest-api", "actions"}, executionType={ExecutionType.SANITY}, description="Verify actions")
    @Test(groups={"rest-api", "actions", "sanity"})
    public void testActionDefinitions() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser());
        RestActionDefinitionModelsCollection restActionDefinitions = this.restClient.withCoreAPI().usingActions().listActionDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertFalse((boolean)restActionDefinitions.isEmpty());
        ((RestModels)((RestModels)((RestModels)restActionDefinitions.assertThat().entriesListContains("name", "copy")).and().entriesListContains("name", "move")).and().entriesListContains("name", "check-out")).and().entriesListContains("name", "check-in");
    }

    @TestRail(section={"rest-api", "actions"}, executionType={ExecutionType.REGRESSION}, description="Verify actions error conditions")
    @Test(groups={"rest-api", "actions", "regression"})
    public void testActionDefinitionsNegative() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser()).withParams(new String[]{"skipCount=-1"}).withCoreAPI().usingActions().listActionDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        UserModel userUnauthorized = new UserModel("invalid-user", "invalid-pasword");
        this.restClient.authenticateUser(userUnauthorized).withCoreAPI().usingActions().listActionDefinitions();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "actions"}, executionType={ExecutionType.SANITY}, description="Sanity test for POST /action-executions")
    @Test(groups={"rest-api", "actions", "sanity"})
    public void executeAction() throws Exception {
        JSONObject response = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingActions().executeAction("add-features", (RepoTestModel)this.document, (Map)ImmutableMap.of((Object)"aspect-name", (Object)"cm:versionable"));
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Assert.assertFalse((boolean)response.getString("id").isEmpty());
        Utility.sleep((int)500, (int)20000, () -> {
            RestNodeModel fileModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.document).getNode();
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            fileModel.assertThat().field("aspectNames").contains("cm:versionable");
        });
    }

    @TestRail(section={"rest-api", "actions"}, executionType={ExecutionType.SANITY}, description="Sanity test for POST /action-executions")
    @Test(groups={"rest-api", "actions", "sanity"})
    public void executeActionWithoutParam() throws Exception {
        JSONObject response = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingActions().executeAction("check-out", (RepoTestModel)this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        Assert.assertFalse((boolean)response.getString("id").isEmpty());
        Utility.sleep((int)500, (int)20000, () -> {
            RestNodeModel fileModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.document).getNode();
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            fileModel.assertThat().field("aspectNames").contains("cm:checkedOut");
        });
    }

    @TestRail(section={"rest-api", "actions"}, executionType={ExecutionType.SANITY}, description="Sanity test for ACTIONS endpoint GET action-definitions/{actionDefinitionId}")
    @Test(groups={"rest-api", "actions", "sanity"})
    public void testGetActionDefinitionById() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser());
        RestActionDefinitionModel restActionDefinition = this.restClient.withCoreAPI().usingActions().getActionDefinitionById("add-features");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertFalse((boolean)restActionDefinition.getId().isEmpty());
        restActionDefinition.getId().equals("add-features");
        restActionDefinition.getDescription().equals("This will add an aspect to the matched item.");
        restActionDefinition.getTitle().equals("Add aspect");
    }
}

