/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.groups;

import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestGroupMember;
import org.alfresco.rest.model.RestGroupsModel;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.utility.RetryOperation;
import org.alfresco.utility.Utility;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class GroupsTests
extends RestTest {
    private UserModel adminUser;
    private UserModel userModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"rest-api", "groups", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify creation, listing, updating and deletion of groups.")
    public void createListUpdateAndDeleteGroup() throws Exception {
        String groupName = "ZtestGroup" + UUID.randomUUID().toString();
        JsonObject groupBody = Json.createObjectBuilder().add("id", groupName).add("displayName", groupName).build();
        String groupBodyCreate = groupBody.toString();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingGroups().createGroup(groupBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        ((RestGroupsModel)((RestGroupsModel)((RestCoreAPI)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingParams(new String[]{"include=zones"})).usingGroups().createGroup(groupBodyCreate).assertThat().field("zones").contains("APP.DEFAULT")).and().field("isRoot").is((Object)true)).and().field("displayName").is((Object)groupName);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestModels)((RestModels)((RestCoreAPI)this.restClient.withCoreAPI().usingParams(new String[]{"orderBy=displayName DESC&maxItems=10"})).usingGroups().listGroups().assertThat().entriesListContains("id", "GROUP_" + groupName)).and().entriesListDoesNotContain("zones")).and().paginationField("maxItems").is("10");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        groupBody = Json.createObjectBuilder().add("displayName", "Z" + groupName).build();
        String groupBodyUpdate = groupBody.toString();
        ((RestGroupsModel)((RestGroupsModel)this.restClient.withCoreAPI().usingGroups().updateGroupDetails("GROUP_" + groupName, groupBodyUpdate).assertThat().field("displayName").is((Object)("Z" + groupName))).and().field("id").is((Object)("GROUP_" + groupName))).and().field("zones").isNull();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestGroupsModel)((RestGroupsModel)((RestCoreAPI)this.restClient.withCoreAPI().usingParams(new String[]{"include=zones"})).usingGroups().getGroupDetail("GROUP_" + groupName).assertThat().field("id").is((Object)("GROUP_" + groupName))).and().field("zones").contains("APP.DEFAULT")).and().field("isRoot").is((Object)true);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingGroups().deleteGroup("GROUP_" + groupName);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingGroups().deleteGroup("GROUP_" + groupName);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "groups", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify creation, listing(only for person) and deletion of group memberships. ")
    public void createListDeleteGroupMembership() throws Exception {
        String groupName = "ZtestGroup" + UUID.randomUUID().toString();
        JsonObject groupBody = Json.createObjectBuilder().add("id", groupName).add("displayName", groupName).build();
        String groupBodyCreate = groupBody.toString();
        ((RestCoreAPI)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingParams(new String[]{"include=zones"})).usingGroups().createGroup(groupBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        JsonObject groupMembershipBody = Json.createObjectBuilder().add("id", this.userModel.getUsername()).add("memberType", "PERSON").build();
        String groupMembershipBodyCreate = groupMembershipBody.toString();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingGroups().createGroupMembership("GROUP_" + groupName, groupMembershipBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingGroups().createGroupMembership("GROUP_" + groupName, groupMembershipBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).listGroupMemberships().assertThat().entriesListContains("id", "GROUP_" + groupName);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.withCoreAPI().usingGroups().deleteGroupMembership("GROUP_" + groupName, this.userModel.getUsername());
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingGroups().deleteGroupMembership("GROUP_" + groupName, this.userModel.getUsername());
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingUser(this.userModel).listGroupMemberships().assertThat().entriesListDoesNotContain("id", "GROUP_" + groupName);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "groups", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify listing of group memberships.")
    public void listGroupMembership() throws Exception {
        final String groupName = "testGroup" + UUID.randomUUID().toString();
        JsonObject groupBody = Json.createObjectBuilder().add("id", groupName).add("displayName", groupName).build();
        String groupBodyCreate = groupBody.toString();
        ((RestCoreAPI)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingParams(new String[]{"include=zones"})).usingGroups().createGroup(groupBodyCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        JsonObject groupMembershipBody = Json.createObjectBuilder().add("id", this.userModel.getUsername()).add("memberType", "PERSON").build();
        String groupMembershipBodyCreate = groupMembershipBody.toString();
        ((RestGroupMember)((RestGroupMember)this.restClient.withCoreAPI().usingGroups().createGroupMembership("GROUP_" + groupName, groupMembershipBodyCreate).assertThat().field("displayName").is((Object)this.userModel.getUsername())).and().field("id").is((Object)this.userModel.getUsername())).and().field("memberType").is((Object)"PERSON");
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RetryOperation op = new RetryOperation(){

            public void execute() throws Exception {
                GroupsTests.this.restClient.withCoreAPI().usingGroups().listGroupMemberships("GROUP_" + groupName).assertThat().entriesListContains("id", GroupsTests.this.userModel.getUsername());
                GroupsTests.this.restClient.assertStatusCodeIs(HttpStatus.OK);
            }
        };
        Utility.sleep((int)500, (int)35000, (RetryOperation)op);
    }
}

