/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.groups;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteGroupModel;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdateSiteGroupTests
extends RestTest {
    private UserModel adminUser;
    private UserModel siteCreator;
    private GroupModel regularGroup;
    private SiteModel publicSite;
    private DataUser.ListUserWithRoles publicSiteUsers;
    private GroupModel groupToBeUpdated;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.siteCreator = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPublicRandomSite();
        this.publicSiteUsers = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.regularGroup = this.dataGroup.createRandomGroup();
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator is not able to update site group membership and gets status code FORBIDDEN (403)")
    public void collaboratorIsNotAbleToUpdateSiteGroup() throws Exception {
        this.groupToBeUpdated = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSite).addSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        this.restClient.assertLastError().containsSummary(String.format("The current user does not have permissions to modify the membership details of the site %s.", this.publicSite.getTitle()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor is not able to update site membership and gets status code FORBIDDEN (403)")
    public void contributorIsNotAbleToUpdateSiteGroup() throws Exception {
        this.groupToBeUpdated = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSite).addSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        this.restClient.assertLastError().containsSummary(String.format("The current user does not have permissions to modify the membership details of the site %s.", this.publicSite.getTitle()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that consumer is not able to update site group and gets status code FORBIDDEN (403)")
    public void consumerIsNotAbleToUpdateSiteGroup() throws Exception {
        this.groupToBeUpdated = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSite).addSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        this.restClient.assertLastError().containsSummary(String.format("The current user does not have permissions to modify the membership details of the site %s.", this.publicSite.getTitle()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin is able to update site member and gets status code OK (200)")
    public void adminIsAbleToUpdateSiteGroup() throws Exception {
        this.groupToBeUpdated = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.adminUser);
        this.restClient.withCoreAPI().usingSite(this.publicSite).addSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteConsumer);
        ((RestSiteGroupModel)this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteCollaborator).assertThat().field("id").is((Object)this.getId(this.groupToBeUpdated))).and().field("role").is((Object)UserRole.SiteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that unauthenticated user is not able to update site member")
    public void unauthenticatedUserIsNotAuthorizedToUpdateSiteGroup() throws Exception {
        this.groupToBeUpdated = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.adminUser);
        this.restClient.withCoreAPI().usingSite(this.publicSite).addSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteConsumer);
        UserModel inexistentUser = new UserModel("inexistent user", "inexistent password");
        this.restClient.authenticateUser(inexistentUser);
        this.restClient.withCoreAPI().usingSite(this.publicSite).updateSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site group request returns status code 404 when nonexistent siteId is used")
    public void updateSiteGroupOfNonexistentSite() throws Exception {
        this.groupToBeUpdated = this.dataGroup.createRandomGroup();
        SiteModel deletedSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.dataSite.deleteSite(deletedSite);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(deletedSite).updateSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, deletedSite.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 400 when personId is not member of the site")
    public void updateNotASiteMember() throws Exception {
        this.groupToBeUpdated = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.publicSite).updateSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("authority is not a member of the site");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 404 when personId does not exist")
    public void updateNonexistentSiteMember() throws Exception {
        GroupModel nonexistentUser = new GroupModel("nonexistentUser");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.publicSite).updateSiteGroup(this.getId(nonexistentUser), UserRole.SiteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format("An authority was not found for %s", this.getId(nonexistentUser)));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 404 when empty siteId is used")
    public void updateSiteMemberUsingEmptySiteId() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite("").updateSiteGroup(this.getId(this.regularGroup), UserRole.SiteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 405 when empty personId is used")
    public void updateSiteMemberUsingEmptyPersonId() throws Exception {
        GroupModel emptyGroup = new GroupModel("");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.publicSite).updateSiteGroup(this.getId(emptyGroup), UserRole.SiteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format("An authority was not found for %s", this.getId(emptyGroup)));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if update site member request returns status code 400 when invalid role is used")
    public void updateSiteMemberUsingInvalidRole() throws Exception {
        this.groupToBeUpdated = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.siteCreator).withCoreAPI();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingSite(this.publicSite).updateSiteGroup(this.getId(this.groupToBeUpdated), UserRole.SiteConsumer);
        String json = JsonBodyGenerator.keyValueJson((String)"role", (String)"invalidRole");
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)json, (String)"sites/{siteId}/group-members/{groupId}", (String[])new String[]{this.publicSite.getId(), this.getId(this.groupToBeUpdated)});
        this.restClient.processModel(RestSiteMemberModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("authority is not a member of the site");
    }

    String getId(GroupModel group) {
        return "GROUP_" + group.getGroupIdentifier();
    }
}

