/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags.nodes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class GetNodeTagsTests
extends TagsDataPrep {
    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify site Manager is able to get node tags")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void siteManagerIsAbleToRetrieveNodeTags() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        returnedCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)returnedCollection.assertThat().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify site Collaborator is able to get node tags")
    @Test(groups={"rest-api", "tags", "regression"})
    public void siteCollaboratorIsAbleToRetrieveNodeTags() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        returnedCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)returnedCollection.assertThat().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify site Contributor is able to get node tags")
    @Test(groups={"rest-api", "tags", "regression"})
    public void siteContributorIsAbleToRetrieveNodeTags() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        returnedCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)returnedCollection.assertThat().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify site Consumer is able to get node tags")
    @Test(groups={"rest-api", "tags", "regression"})
    public void siteConsumerIsAbleToRetrieveNodeTags() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        returnedCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)returnedCollection.assertThat().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to get node tags")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsAbleToRetrieveNodeTags() throws Exception {
        this.restClient.authenticateUser(adminUserModel);
        returnedCollection = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)returnedCollection.assertThat().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user is not able to get node tags")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void unauthenticatedUserIsNotAbleToRetrieveNodeTags() throws Exception {
        this.restClient.authenticateUser(new UserModel("random user", "random password"));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that using invalid value for skipCount parameter returns status code 400")
    @Test(groups={"rest-api", "tags", "regression"})
    public void invalidSkipCountTest() throws Exception {
        this.restClient.withParams(new String[]{"skipCount=abc"}).withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "abc"));
        this.restClient.withParams(new String[]{"skipCount=-1"}).withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that using invalid value for maxItems parameter returns status code 400")
    @Test(groups={"rest-api", "tags", "regression"})
    public void invalidMaxItemsTest() throws Exception {
        this.restClient.withParams(new String[]{"maxItems=abc"}).withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "abc"));
        this.restClient.withParams(new String[]{"maxItems=-1"}).withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that user without permissions returns status code 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void userWithoutPermissionsTest() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(adminUserModel)).createModeratedRandomSite();
        FileModel moderatedDocument = ((DataContent)this.dataContent.usingSite(moderatedSite)).usingUser(adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.dataUser.createRandomTestUser()).withCoreAPI().usingResource((RepoTestModel)moderatedDocument).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if node does not exist returns status code 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void nonexistentNodeTest() throws Exception {
        FileModel badDocument = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String nodeRef = RandomStringUtils.randomAlphanumeric((int)10);
        badDocument.setNodeRef(nodeRef);
        this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)badDocument).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, nodeRef));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if node id is empty returns status code 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void emptyNodeIdTest() throws Exception {
        FileModel badDocument = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        badDocument.setNodeRef("");
        this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)badDocument).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify folder tags")
    @Test(groups={"rest-api", "tags", "regression"})
    public void folderTagsTest() throws Exception {
        FolderModel folder = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folder).addTag(documentTagValue);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folder).addTag(documentTagValue2);
        ((RestModels)this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)folder).getNodeTags().assertThat().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify site Manager is able to get node tags using properties parameter")
    @Test(groups={"rest-api", "tags", "regression"})
    public void siteManagerIsAbleToRetrieveNodeTagsWithPropertiesParameter() throws Exception {
        returnedCollection = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"properties=tag"}).withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase())).and().entriesListDoesNotContain("id");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that Collaborator user is not able to get node tags using site id instead of node id")
    @Test(groups={"rest-api", "tags", "regression"})
    public void collaboratorGetNodeTagsUseSiteIdInsteadOfNodeId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        file.setNodeRef(siteModel.getId());
        returnedCollection = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, file.getNodeRef()));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With admin get node tags and use skipCount parameter. Check pagination and maxItems")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useSkipCountCheckPaginationAndMaxItems() throws Exception {
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"skipCount=1"}).withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)returnedCollection.getPagination().assertThat().field("maxItems").is((Object)100)).and().field("hasMoreItems").is((Object)"false")).and().field("count").isGreaterThan(Integer.valueOf(1));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With admin get node tags and use maxItems parameter. Check pagination")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useMaxItemsParameterCheckPagination() throws Exception {
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"maxItems=1"}).withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)returnedCollection.getPagination().assertThat().field("maxItems").is((Object)1)).and().field("hasMoreItems").is((Object)"true")).and().field("count").is((Object)"1")).and().field("skipCount").is((Object)"0");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Using manager user get only one tag.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void usingManagerGetOnlyOneTag() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingAdmin().usingSite(siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addTag(documentTagValue);
        returnedCollection = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)returnedCollection.getPagination().assertThat().field("maxItems").is((Object)100)).and().field("hasMoreItems").is((Object)"false")).and().field("totalItems").is((Object)"1")).and().field("count").is((Object)"1")).and().field("skipCount").is((Object)"0");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Using admin get last 2 tags and skip first 2 tags")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminUserGetLast2TagsAndSkipFirst2Tags() throws Exception {
        String firstTag = "1st tag";
        String secondTag = "2nd tag";
        String thirdTag = "3rd tag";
        String fourthTag = "4th tag";
        FileModel file = ((DataContent)this.dataContent.usingAdmin().usingSite(siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addTag(firstTag);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).addTag(secondTag);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).addTag(thirdTag);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).addTag(fourthTag);
        returnedCollection = this.restClient.withParams(new String[]{"skipCount=2"}).withCoreAPI().usingResource((RepoTestModel)file).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)returnedCollection.assertThat().entriesListContains("tag", thirdTag.toLowerCase())).and().entriesListContains("tag", fourthTag.toLowerCase());
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)returnedCollection.getPagination().assertThat().field("maxItems").is((Object)100)).and().field("hasMoreItems").is((Object)"false")).and().field("totalItems").is((Object)"4")).and().field("count").is((Object)"2")).and().field("skipCount").is((Object)"2");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With admin get node tags and use maxItems=0.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagsWithZeroMaxItems() throws Exception {
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"maxItems=0"}).withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that using high skipCount parameter returns status code 200.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagsWithHighSkipCount() throws Exception {
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"skipCount=10000"}).withCoreAPI().usingResource((RepoTestModel)document).getNodeTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)returnedCollection.getPagination().assertThat().field("maxItems").is((Object)100)).and().field("hasMoreItems").is((Object)"false")).and().field("count").is((Object)"0")).and().field("skipCount").is((Object)"10000");
        returnedCollection.assertThat().entriesListCountIs(0);
    }
}

