/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessVariablesCoreTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private RestProcessModel processModel;
    private RestProcessVariableModel variableModel;
    private RestProcessVariableModel processVariable;
    private RestProcessVariableModel variableModel1;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsProcess)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify addProcessVariable by any user for invalid processID with REST API and status code is NOT_FOUND (404)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessVariableForInvalidProcessIdIsNotFound() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processModel.setId("invalidProcessID");
        this.processVariable = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidProcessID"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify addProcessVariable by any user for empty processID with REST API and status code is NOT_FOUND (404)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessVariableForEmptyProcessIdIsEmpty() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processModel.setId("");
        this.processVariable = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple process variables is falling in case invalid process id is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addMultipleProcessVariablesInvalidProcessId() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:int");
        this.variableModel1 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processModel.setId("invalidProcessID");
        this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel1, this.variableModel});
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidProcessID"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple process variables is falling in case empty process id is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addMultipleProcessVariablesEmptyProcessId() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:int");
        this.variableModel1 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processModel.setId("");
        this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel1, this.variableModel});
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }
}

