/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RemoveTaskItemTests
extends RestTest {
    private UserModel adminUser;
    private UserModel userWhoStartsTask;
    private UserModel assigneeUser;
    private SiteModel siteModel;
    private FileModel fileModel;
    private FileModel document2;
    private TaskModel taskModel;
    private RestItemModel taskItem;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.assigneeUser = this.dataUser.createRandomTestUser();
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Delete existing task item")
    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    public void deleteTaskItem() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.adminUser);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestModels)this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskItems().assertThat().entriesListDoesNotContain("id", this.taskItem.getId())).and().entriesListDoesNotContain("name", this.document2.getName());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Try to Delete existing task item using invalid taskId")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemUsingInvalidTaskId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.adminUser);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.taskModel.setId("invalidTaskId");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidTaskId"));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Try to Delete existing task item using invalid itemId")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemUsingInvalidItemId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.adminUser);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.taskItem.setId("incorrectItemId");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.PROCESS_ENTITY_NOT_FOUND, "incorrectItemId"));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete existing task item with empty task id")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemEmptyTaskId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.taskModel.setId("");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete existing task item with empty item id")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemEmptyItemId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.taskItem.setId("");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.DELETE_EMPTY_ARGUMENT);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete existing task item for completed task")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemForCompletedTask() throws Exception {
        TaskModel completedTask = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document2 = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(completedTask).addTaskItem(this.document2);
        ((DataWorkflow)this.dataWorkflow.usingUser(this.assigneeUser)).taskDone(completedTask);
        ((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).taskDone(completedTask);
        this.restClient.withWorkflowAPI().usingTask(completedTask).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, completedTask.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Delete existing task item with candidate user")
    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    public void deleteTaskItemWithCandidateUser() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(group, new UserModel[]{this.assigneeUser});
        TaskModel groupTask = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(group);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document2 = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(groupTask).addTaskItem(this.document2);
        this.restClient.authenticateUser(this.assigneeUser).withWorkflowAPI().usingTask(groupTask).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete existing task item with unauthorized user")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemWithUnauthorizedUser() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        UserModel unauthorizedUser = this.dataUser.createRandomTestUser();
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.restClient.authenticateUser(unauthorizedUser).withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Delete existing task item with inexistent user")
    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    public void deleteTaskItemWithInexistentUser() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.restClient.authenticateUser(UserModel.getRandomUserModel()).withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete existing task item for deleted task")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemFromDeletedProcess() throws Exception {
        ProcessModel deletedProcess = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createMoreReviewersWorkflowAndAssignTo(new UserModel[]{this.assigneeUser});
        RestTaskModel task = ((RestTaskModel)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingProcess(deletedProcess).getProcessTasks().getEntries().get(0)).onModel();
        this.document2 = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask((TaskModel)task).addTaskItem(this.document2);
        ((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).deleteProcess(deletedProcess);
        this.restClient.withWorkflowAPI().usingTask((TaskModel)task).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, task.getId()));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task item twice")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemTwice() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.PROCESS_ENTITY_NOT_FOUND, this.document2.getNodeRefWithoutVersion())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task item with locked document")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemWithLockedDocument() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingResource((ContentModel)this.document2)).checkOutDocument();
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT).assertLastError().containsSummary(String.format(RestErrorModel.LOCKED_NODE_OPERATION, this.document2.getNodeRefWithoutVersion())).containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task item with deleted document")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskItemWithDeletedDocument() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.document2 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.taskItem = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(this.document2);
        ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingResource((ContentModel)this.document2)).deleteContent();
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskItem(this.taskItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.PROCESS_ENTITY_NOT_FOUND, this.document2.getNodeRefWithoutVersion())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

