/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags;

import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTagModelsCollection;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class GetTagsTests
extends TagsDataPrep {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.init();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role gets tags using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void getTagsWithManagerRole() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets tags using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagsWithCollaboratorRole() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets tags using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagsWithContributorRole() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets tags using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "tags", "regression"})
    public void getTagsWithConsumerRole() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Failed authentication get tags call returns status code 401 with Manager role")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void failedAuthenticationReturnsUnauthorizedStatus() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        userModel = this.dataUser.createRandomTestUser();
        userModel.setPassword("user wrong password");
        this.dataUser.addUserToSite(userModel, siteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(userModel);
        this.restClient.withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if maxItems is invalid status code returned is 400")
    @Test(groups={"rest-api", "tags", "regression"})
    public void maxItemsInvalidValueTest() throws Exception {
        this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"maxItems=abc"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "abc"));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if skipCount is invalid status code returned is 400")
    @Test(groups={"rest-api", "tags", "regression"})
    public void skipCountInvalidValueTest() throws Exception {
        this.restClient.authenticateUser(adminUserModel).withParams(new String[]{"skipCount=abc"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "abc"));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that file tag is retrieved")
    @Test(groups={"rest-api", "tags", "regression"})
    public void fileTagIsRetrieved() throws Exception {
        this.restClient.authenticateUser(adminUserModel);
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that folder tag is retrieved")
    @Test(groups={"rest-api", "tags", "regression"})
    public void folderTagIsRetrieved() throws Exception {
        this.restClient.authenticateUser(adminUserModel);
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("tag", folderTagValue.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify site Manager is able to get tags using properties parameter.Check that properties filter is applied.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void siteManagerIsAbleToRetrieveTagsWithPropertiesParameter() throws Exception {
        returnedCollection = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"maxItems=5000&properties=tag"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("tag", documentTagValue.toLowerCase())).and().entriesListContains("tag", documentTagValue2.toLowerCase())).and().entriesListDoesNotContain("id");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With admin get tags and use skipCount parameter. Check pagination")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useSkipCountCheckPagination() throws Exception {
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestTagModel firstTag = ((RestTagModel)returnedCollection.getEntries().get(0)).onModel();
        RestTagModel secondTag = ((RestTagModel)returnedCollection.getEntries().get(1)).onModel();
        RestTagModelsCollection tagsWithSkipCount = this.restClient.withParams(new String[]{"skipCount=2"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)tagsWithSkipCount.assertThat().entriesListDoesNotContain("tag", firstTag.getTag())).assertThat().entriesListDoesNotContain("tag", secondTag.getTag());
        tagsWithSkipCount.assertThat().paginationField("skipCount").is("2");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With admin get tags and use maxItems parameter. Check pagination")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useMaxItemsParameterCheckPagination() throws Exception {
        returnedCollection = this.restClient.authenticateUser(adminUserModel).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestTagModel firstTag = ((RestTagModel)returnedCollection.getEntries().get(0)).onModel();
        RestTagModel secondTag = ((RestTagModel)returnedCollection.getEntries().get(1)).onModel();
        RestTagModelsCollection tagsWithMaxItems = this.restClient.withParams(new String[]{"maxItems=2"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)tagsWithMaxItems.assertThat().entriesListContains("tag", firstTag.getTag())).assertThat().entriesListContains("tag", secondTag.getTag())).assertThat().entriesListCountIs(2);
        tagsWithMaxItems.assertThat().paginationField("maxItems").is("2");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With manager get tags and use high skipCount parameter. Check pagination")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useHighSkipCountCheckPagination() throws Exception {
        returnedCollection = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"skipCount=20000"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestModels)returnedCollection.assertThat().entriesListIsEmpty()).getPagination().assertThat().field("maxItems").is((Object)100)).and().field("hasMoreItems").is((Object)"false")).and().field("count").is((Object)"0")).and().field("skipCount").is((Object)20000)).and().field("totalItems").isNull();
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With Collaborator user get tags and use maxItems with value zero. Check default error model schema")
    @Test(groups={"rest-api", "tags", "regression"})
    public void useMaxItemsWithValueZeroCheckDefaultErrorModelSchema() throws Exception {
        returnedCollection = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"maxItems=0"}).withCoreAPI().getTags();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="With Manager user delete tag. Check it is not retrieved anymore.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void checkThatDeletedTagIsNotRetrievedAnymore() throws Exception {
        String removedTag = RandomData.getRandomName((String)"tag3");
        RestTagModel deletedTag = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).addTag(removedTag);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(deletedTag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        returnedCollection = this.restClient.withParams(new String[]{"maxItems=10000"}).withCoreAPI().getTags();
        ((RestModels)returnedCollection.assertThat().entriesListIsNotEmpty()).and().entriesListDoesNotContain("tag", removedTag.toLowerCase());
    }
}

