/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags;

import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class UpdateTagTests
extends TagsDataPrep {
    private RestTagModel oldTag;
    private String randomTag = "";

    @BeforeMethod(alwaysRun=true)
    public void addTagToDocument() throws Exception {
        this.restClient.authenticateUser(adminUserModel);
        this.oldTag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"old"));
        this.randomTag = RandomData.getRandomName((String)"tag");
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Admin user updates tags and status code is 200")
    @Bug(id="REPO-1828")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void adminIsAbleToUpdateTags() throws Exception {
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)this.randomTag);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user can't update tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void managerIsNotAbleToUpdateTag() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user can't update tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void collaboratorIsNotAbleToUpdateTagCheckDefaultErrorModelSchema() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user can't update tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void contributorIsNotAbleToUpdateTag() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Consumer user can't update tags with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void consumerIsNotAbleToUpdateTag() throws Exception {
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void userIsNotAbleToUpdateTagIfAuthenticationFails() throws Exception {
        UserModel siteManager = usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        String managerPassword = siteManager.getPassword();
        siteManager.setPassword("wrongPassword");
        this.restClient.authenticateUser(siteManager);
        this.restClient.withCoreAPI().usingTag(this.oldTag).update(this.randomTag);
        siteManager.setPassword(managerPassword);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with invalid id")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsNotAbleToUpdateTagWithInvalidId() throws Exception {
        String invalidTagId = "invalid-id";
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        tag.setId(invalidTagId);
        this.restClient.withCoreAPI().usingTag(tag).update(RandomData.getRandomName((String)"tag"));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, invalidTagId));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with empty id")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsNotAbleToUpdateTagWithEmptyId() throws Exception {
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        tag.setId("");
        this.restClient.withCoreAPI().usingTag(tag).update(RandomData.getRandomName((String)"tag"));
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.PUT_EMPTY_ARGUMENT);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with invalid body")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsNotAbleToUpdateTagWithEmptyBody() throws Exception {
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.withCoreAPI().usingTag(tag).update("");
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.EMPTY_TAG);
    }

    @Bug(id="ACE-5629")
    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with invalid body containing '|' symbol")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsNotAbleToUpdateTagWithInvalidBodyScenario1() throws Exception {
        String invalidTagBody = "|.\"/<>*";
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        Utility.sleep((int)500, (int)20000, () -> {
            this.restClient.withCoreAPI().usingTag(tag).update(invalidTagBody);
            this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_TAG, invalidTagBody));
        });
    }

    @Bug(id="ACE-5629")
    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update tag with invalid body without '|' symbol")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsNotAbleToUpdateTagWithInvalidBodyScenario2() throws Exception {
        String invalidTagBody = ".\"/<>*";
        RestTagModel tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        Utility.sleep((int)500, (int)20000, () -> {
            this.restClient.withCoreAPI().usingTag(tag).update(invalidTagBody);
            this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_TAG, invalidTagBody));
        });
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user can provide large string for new tag value.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    public void adminIsAbleToUpdateTagsProvideLargeStringTag() throws Exception {
        String largeStringTag = RandomStringUtils.randomAlphanumeric((int)10000);
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(this.oldTag).update(largeStringTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)largeStringTag);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user can provide short string for new tag value.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    public void adminIsAbleToUpdateTagsProvideShortStringTag() throws Exception {
        String shortStringTag = RandomStringUtils.randomAlphanumeric((int)2);
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(this.oldTag).update(shortStringTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)shortStringTag);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user can provide string with special chars for new tag value.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    public void adminIsAbleToUpdateTagsProvideSpecialCharsStringTag() throws Exception {
        String specialCharsString = "!@#$%^&*()'\".,<>-_+=|\\";
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(this.oldTag).update(specialCharsString);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)specialCharsString);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can provide existing tag for new tag value.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    public void adminIsAbleToUpdateTagsProvideExistingTag() throws Exception {
        String existingTag = "oldTag";
        RestTagModel oldExistingTag = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).addTag(existingTag);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(adminUserModel);
        returnedModel = this.restClient.withCoreAPI().usingTag(oldExistingTag).update(existingTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)existingTag);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can delete a tag, add tag and update it.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    public void adminDeleteTagAddTagUpdateTag() throws Exception {
        this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.oldTag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        String newTag = "addTag";
        RestTagModel newTagModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(newTag);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        returnedModel = this.restClient.withCoreAPI().usingTag(newTagModel).update(newTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)newTag);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can update a tag, delete tag and add it.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="REPO-1828")
    public void adminUpdateTagDeleteTagAddTag() throws Exception {
        String newTag = "addTag";
        returnedModel = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingTag(this.oldTag).update(newTag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedModel.assertThat().field("tag").is((Object)newTag);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(returnedModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(newTag);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }
}

