/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessVariableFullTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private UserModel adminUser;
    private RestProcessModel processModel;
    private RestProcessVariableModel variableModel;
    private RestProcessVariableModel processVariable;
    private RestProcessVariableModel updatedProcessVariable;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsProcess)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify addProcessVariable by any user for invalid processID with REST API and status code is NOT_FOUND (404)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessVariableWithInvalidProcessId() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processModel.setId("invalidProcessID");
        this.processVariable = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidProcessID"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify addProcessVariable by any user for empty processID with REST API and status code is NOT_FOUND (404)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addProcessVariableWithEmptyProcessId() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processModel.setId("");
        this.processVariable = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable in case of having only 'name' field is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addingProcessVariableWithOnlyNameProvided() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"name\": \"variableName\"}", (String)"processes/{processId}/variables/{variableName}", (String[])new String[]{this.processModel.getId(), "variableName"});
        this.processVariable = (RestProcessVariableModel)this.restClient.processModel(RestProcessVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)"variableName")).and().field("type").is((Object)"d:any")).and().field("value").isNull();
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable in case of missing type field is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addingProcessVariableIfMissingValueIsProvided() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"name\": \"variableName\", \"type\": \"d:text\"}", (String)"processes/{processId}/variables/{variableName}", (String[])new String[]{this.processModel.getId(), "variableName"});
        this.processVariable = (RestProcessVariableModel)this.restClient.processModel(RestProcessVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)"variableName")).and().field("type").is((Object)"d:text")).and().field("value").isNull();
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable in case of missing type field is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addingProcessVariableIfMissingTypeIsProvided() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"value\": \"variableValue\", \"name\": \"variableName\"}", (String)"processes/{processId}/variables/{variableName}", (String[])new String[]{this.processModel.getId(), "variableValue"});
        this.processVariable = (RestProcessVariableModel)this.restClient.processModel(RestProcessVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)"variableName")).and().field("type").is((Object)"d:text")).and().field("value").is((Object)"variableValue");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable is case of empty type value is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addingProcessVariableIfEmptyTypeIsProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)"d:text")).and().field("value").is((Object)this.variableModel.getValue());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Adding process variable in case of empty body field is provided")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void addingProcessVariableWithEmptyBodyProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{ }", (String)"processes/{processId}/variables/{variableName}", (String[])new String[]{this.processModel.getId(), this.variableModel.getName()});
        this.processVariable = (RestProcessVariableModel)this.restClient.processModel(RestProcessVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.VARIABLE_NAME_REQUIRED).containsSummary(RestErrorModel.VARIABLE_NAME_REQUIRED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Update twice in a row the same variable.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void updateTwiceInARowSameProcessVariable() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables().assertThat().entriesListContains("name", this.variableModel.getName());
        this.updatedProcessVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).updateProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.updatedProcessVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables().assertThat().entriesListContains("name", this.variableModel.getName());
    }
}

