/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateFolderTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;
    FolderModel testFolder;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can create folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void adminShouldCreateFolder() throws Exception {
        FolderModel guest = FolderModel.getGuestHomeFolderModel();
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)guest).createFolder(this.testFolder).and()).assertThat().hasStatus(201).then()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can create folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManagerShouldCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().hasStatus(201).then()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with contributor role can create folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteContributorShouldCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(contributor).usingSite(this.testSite).createFolder(this.testFolder).assertThat().hasStatus(201).then()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with collaborator role can create folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteCollaboraShouldCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(collaborator).usingSite(this.testSite).createFolder(this.testFolder).assertThat().hasStatus(201).then()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with consumer role cannot create folder")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteConsumerShouldCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(consumer).usingSite(this.testSite).createFolder(this.testFolder).assertThat().hasStatus(403).then()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav().and()).assertThat().hasStatus(404);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with manager role can create folder with spaces in name")
    @Test(groups={"protocols", "webdav", "sanity"})
    public void siteManageShouldCreateFolderWithSpacesInName() throws Exception {
        this.testFolder = new FolderModel("test folder " + RandomData.getRandomFolder());
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).assertThat().hasStatus(201).then()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().and()).assertThat().hasStatus(200);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that user with manager role cannot create folder with special characters in name")
    @Test(groups={"protocols", "webdav", "core"}, expectedExceptions={IllegalArgumentException.class})
    public void siteManageShouldNotCreateFolderWithSpecialChars() throws Exception {
        this.testFolder = new FolderModel("<>.|?#()[]{}");
        this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager cannot create folder twice in the same location")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerShouldNotCreateFolderTwice() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().hasStatus(201).then()).assertThat().existsInRepo()).when()).createFolder(this.testFolder).assertThat().hasStatus(405);
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user cannot create folder")
    @Test(groups={"protocols", "webdav", "core"})
    public void inexistentUserShouldNotCreateFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(UserModel.getRandomUserModel()).usingResource((ContentModel)FolderModel.getSharedFolderModel()).createFolder(this.testFolder).and()).assertThat().hasStatus(401).then()).usingAdmin()).assertThat().doesNotExistInRepo()).and()).assertThat().doesNotExistInWebdav();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user cannot create folder")
    @Test(groups={"protocols", "webdav", "core"})
    public void unauthorizedUserShouldNotCreateFolder() throws Exception {
        UserModel unauthorized = this.dataUser.createRandomTestUser();
        this.testFolder = FolderModel.getRandomFolderModel();
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(unauthorized).usingRoot().createFolder(this.testFolder).and()).assertThat().hasStatus(403).then()).assertThat().doesNotExistInRepo()).assertThat().doesNotExistInWebdav();
    }
}

