/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webdav;

import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.webdav.WebDavTest;
import org.alfresco.webdav.WebDavWrapper;
import org.apache.commons.lang3.RandomStringUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RenameFolderTests
extends WebDavTest {
    UserModel managerUser;
    SiteModel testSite;
    FolderModel testFolder;
    private String renamePrefix = "-edit";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that admin user can rename folder")
    public void adminShouldRenameFolder() throws Exception {
        FolderModel guest = FolderModel.getGuestHomeFolderModel();
        this.testFolder = FolderModel.getRandomFolderModel();
        FolderModel originalFolderModel = new FolderModel(this.testFolder);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingResource((ContentModel)guest).createFolder(this.testFolder).and()).assertThat().existsInRepo()).when()).rename(this.testFolder.getName() + this.renamePrefix).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingSite(this.testSite).usingResource((ContentModel)originalFolderModel).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can rename folder")
    public void siteManagerShouldRenameFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        FolderModel originalFolderModel = new FolderModel(this.testFolder);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo()).when()).rename(this.testFolder.getName() + this.renamePrefix).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingSite(this.testSite).usingResource((ContentModel)originalFolderModel).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with contributor role cannot rename folder")
    public void siteContributorShouldNotRenameFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        FolderModel originalFolderModel = new FolderModel(this.testFolder);
        UserModel contributor = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(contributor, this.testSite, UserRole.SiteContributor);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo()).when()).authenticateUser(contributor).usingResource((ContentModel)this.testFolder).rename(this.testFolder.getName() + this.renamePrefix).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).then()).usingSite(this.testSite).usingResource((ContentModel)originalFolderModel).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with collaborator role can rename folder")
    public void siteCollaboratorShouldRenameFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        FolderModel originalFolderModel = new FolderModel(this.testFolder);
        UserModel collaborator = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(collaborator, this.testSite, UserRole.SiteCollaborator);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo()).when()).authenticateUser(collaborator).usingResource((ContentModel)this.testFolder).rename(this.testFolder.getName() + this.renamePrefix).assertThat().existsInRepo()).and()).assertThat().hasStatus(201).then()).usingSite(this.testSite).usingResource((ContentModel)originalFolderModel).assertThat().doesNotExistInRepo();
    }

    @Test(groups={"protocols", "webdav", "sanity"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.SANITY}, description="Verify that user with consumer role cannot rename folder")
    public void siteConsumerShouldNotRenameFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        FolderModel originalFolderModel = new FolderModel(this.testFolder);
        UserModel consumer = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(consumer, this.testSite, UserRole.SiteConsumer);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo()).when()).authenticateUser(consumer).usingResource((ContentModel)this.testFolder).rename(this.testFolder.getName() + this.renamePrefix).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(403).then()).usingSite(this.testSite).usingResource((ContentModel)originalFolderModel).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that disconected user cannot rename a folder")
    public void disconectedUserShouldNotRenameFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        FolderModel originalFolderModel = new FolderModel(this.testFolder);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo()).when()).disconnect().usingResource((ContentModel)this.testFolder).rename(this.testFolder.getName() + this.renamePrefix).assertThat().doesNotExistInRepo()).and()).assertThat().hasStatus(401);
        this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).usingResource((ContentModel)originalFolderModel).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that unauthorized user cannot rename a folder")
    public void unauthorizedUserShouldNotRenameFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        FolderModel originalFolderModel = new FolderModel(this.testFolder);
        this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingRoot().createFolder(this.testFolder).assertThat().existsInRepo();
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.dataUser.createRandomTestUser()).usingResource((ContentModel)this.testFolder).rename(this.testFolder.getName() + this.renamePrefix).assertThat().doesNotExistInRepo()).assertThat().hasStatus(403);
        this.webDavProtocol.authenticateUser(this.dataUser.getAdminUser()).usingRoot().usingResource((ContentModel)originalFolderModel).assertThat().existsInRepo();
    }

    @Test(groups={"protocols", "webdav", "core"})
    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent user cannot rename a folder")
    public void inexistentUserShouldNotRenameFolder() throws Exception {
        this.testFolder = FolderModel.getRandomFolderModel();
        FolderModel originalFolderModel = new FolderModel(this.testFolder);
        ((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo();
        this.webDavProtocol.authenticateUser(UserModel.getRandomUserModel()).usingResource((ContentModel)this.testFolder).rename(this.testFolder.getName() + this.renamePrefix).assertThat().hasStatus(401);
        this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).usingResource((ContentModel)originalFolderModel).assertThat().existsInRepo();
    }

    @TestRail(section={"protocols", "webdav"}, executionType={ExecutionType.REGRESSION}, description="Verify that site manager can rename folder with 200 characters")
    @Test(groups={"protocols", "webdav", "core"})
    public void siteManagerShouldRenameFolderWithLongName() throws Exception {
        String longName = RandomStringUtils.randomAlphabetic((int)200);
        this.testFolder = FolderModel.getRandomFolderModel();
        FolderModel originalFolderModel = new FolderModel(this.testFolder);
        ((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)((WebDavWrapper)this.webDavProtocol.authenticateUser(this.managerUser).usingSite(this.testSite).createFolder(this.testFolder).and()).assertThat().existsInRepo()).when()).rename(longName).and()).assertThat().hasStatus(201).and()).assertThat().existsInRepo()).and()).assertThat().existsInWebdav().then()).usingSite(this.testSite).usingResource((ContentModel)originalFolderModel).assertThat().doesNotExistInRepo();
    }
}

