/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetExtensionTests
extends CmisTest {
    UserModel testUser;
    UserModel nonInvitedUser;
    SiteModel testSite;
    FileModel testFile;
    FileModel managerFile;
    FolderModel managerFolder;
    private DataUser.ListUserWithRoles usersWithRoles;
    private String titledAspect = "P:cm:titled";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.managerFile = FileModel.getRandomFileModel((FileType)FileType.XML, (String)this.documentContent);
        this.managerFolder = FolderModel.getRandomFolderModel();
        this.testUser = this.dataUser.createRandomTestUser();
        this.nonInvitedUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.usersWithRoles = ((DataUser)this.dataUser.usingUser(this.testUser)).addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator, UserRole.SiteConsumer});
        this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.managerFile).createFolder(this.managerFolder);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Site manager can get extensions from a valid folder")
    @Test(groups={"bug-ws-REPO-5394", "sanity", "cmis"})
    public void siteManagerCanGetExtensionsForValidFolder() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFolder).assertThat().hasAspectExtension(this.titledAspect);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Site manager can get extensions from a valid file")
    @Test(groups={"bug-ws-REPO-5394", "sanity", "cmis"})
    public void siteManagerCanGetExtensionsForValidFile() throws Exception {
        this.cmisApi.authenticateUser(this.testUser).usingResource((ContentModel)this.managerFile).assertThat().hasAspectExtension(this.titledAspect);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site manager cannot get extensions from an invalid document - that was deleted")
    @Test(groups={"bug-ws-REPO-5394", "regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    public void siteManagerCannotGetExtensionsForInvalidDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).then()).assertThat().hasAspectExtension(this.titledAspect).and()).delete().then()).assertThat().hasAspectExtension(this.titledAspect);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site manager can get extensions from checkedout document")
    @Test(groups={"bug-ws-REPO-5394", "regression", "cmis"})
    public void siteManagerCanGetExtensionsForCheckedOutDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.MSWORD, (String)this.documentContent);
        ((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(this.testSite).createFile(this.testFile).checkOut().then()).assertThat().hasAspectExtension(this.titledAspect).then()).usingPWCDocument().assertThat().hasAspectExtension(this.titledAspect);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site collaborator can get extensions")
    @Test(groups={"bug-ws-REPO-5394", "regression", "cmis"})
    public void collaboratorCanGetExtensions() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.managerFolder).assertThat().hasAspectExtension(this.titledAspect).then()).usingResource((ContentModel)this.managerFile).assertThat().hasAspectExtension(this.titledAspect);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site contributor can get extensions")
    @Test(groups={"bug-ws-REPO-5394", "regression", "cmis"})
    public void contributorCanGetExtensions() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingResource((ContentModel)this.managerFolder).assertThat().hasAspectExtension(this.titledAspect).then()).usingResource((ContentModel)this.managerFile).assertThat().hasAspectExtension(this.titledAspect);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Site consumer can get extensions")
    @Test(groups={"bug-ws-REPO-5394", "regression", "cmis"})
    public void consumerCanGetExtensions() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.managerFolder).assertThat().hasAspectExtension(this.titledAspect).then()).usingResource((ContentModel)this.managerFile).assertThat().hasAspectExtension(this.titledAspect);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Non invited user can get extensions in public site")
    @Test(groups={"bug-ws-REPO-5394", "regression", "cmis"})
    public void nonInvitedUserCanGetExtensionsInPublicSite() throws Exception {
        ((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingResource((ContentModel)this.managerFolder).assertThat().hasAspectExtension(this.titledAspect).then()).usingResource((ContentModel)this.managerFile).assertThat().hasAspectExtension(this.titledAspect);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Non invited user cannot get extensions in private site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotGetExtensionsInPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        FileModel privateDoc = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(privateSite).createFile(privateDoc).then()).authenticateUser(this.nonInvitedUser).assertThat().hasAspectExtension(this.titledAspect);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Non invited user cannot get extensions in moderated site")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisPermissionDeniedException.class})
    public void nonInvitedUserCannotGetExtensionsInModeratedSite() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPrivateRandomSite();
        FileModel moderatedDoc = FileModel.getRandomFileModel((FileType)FileType.HTML, (String)this.documentContent);
        ((CmisWrapper)this.cmisApi.authenticateUser(this.testUser).usingSite(moderatedSite).createFile(moderatedDoc).then()).authenticateUser(this.nonInvitedUser).assertThat().hasAspectExtension(this.titledAspect);
    }
}

