/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.cmis.CmisWrapper;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CancelCheckOutTests
extends CmisTest {
    UserModel siteManager;
    SiteModel testSite;
    FileModel testFile;
    private String fileContent = "content";
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteManager = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.siteManager)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.testSite, new UserRole[]{UserRole.SiteContributor, UserRole.SiteCollaborator});
    }

    @Test(groups={"sanity", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify cancel check out on a pwc")
    public void cancelCheckOutOnPWC() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).checkOut().and()).assertThat().documentIsCheckedOut().and()).assertThat().isPrivateWorkingCopy().then()).cancelCheckOut().and()).assertThat().isNotPrivateWorkingCopy().and()).assertThat().existsInRepo().and()).assertThat().documentIsNotCheckedOut();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify cancel check out on a document that isn't checked out")
    @Test(groups={"bug-atom-REPO-5383", "regression", "cmis"}, expectedExceptions={CmisRuntimeException.class})
    public void cancelCheckOutOnADocumentThatIsntCheckedOut() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).assertThat().isNotPrivateWorkingCopy().then()).cancelCheckOut();
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisObjectNotFoundException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify cancel check out on deleted document")
    public void cancelCheckOutOnDeletedDocument() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().then()).delete().and()).assertThat().doesNotExistInRepo().then()).cancelCheckOut();
    }

    @Test(groups={"bug-atom-REPO-5383", "regression", "cmis"}, expectedExceptions={CmisRuntimeException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify cancel check out on a pwc twice")
    public void cancelCheckOutTwice() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().assertThat().isPrivateWorkingCopy().and()).cancelCheckOut().cancelCheckOut();
    }

    @Test(groups={"not_supported_on_single_pipeline", "regression", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that cancel check out on document created with Versioning State CHECKED OUT deletes the document")
    public void cancelCheckOutOnDocWithVersioningStateCheckedOut() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile, VersioningState.CHECKEDOUT).and()).assertThat().existsInRepo().assertThat().documentIsCheckedOut().then()).usingPWCDocument().cancelCheckOut().and()).assertThat().doesNotExistInRepo().usingResource((ContentModel)this.testFile).assertThat().doesNotExistInRepo();
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator user can cancel check out on document created by self")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanCancelCheckInDocumentCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).cancelCheckOut().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.0);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that collaborator user can cancel check out on document created by manager")
    @Test(groups={"regression", "cmis"})
    public void collaboratorCanCancelCheckInDocumentCreatedByManager() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.siteManager).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).cancelCheckOut().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.0);
    }

    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that contributor user can cancel check out on document created by self")
    @Test(groups={"regression", "cmis"})
    public void contributorCanCancelCheckInDocumentCreatedBySelf() throws Exception {
        this.testFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN, (String)this.fileContent);
        ((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)((CmisWrapper)this.cmisApi.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).usingSite(this.testSite).createFile(this.testFile).and()).assertThat().existsInRepo().and()).checkOut().and()).assertThat().documentIsCheckedOut().and()).cancelCheckOut().and()).assertThat().documentIsNotCheckedOut().then()).assertThat().documentHasVersion(1.0);
    }
}

