/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import org.alfresco.cmis.CmisTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RepositoryInfoTests
extends CmisTest {
    UserModel testUser;
    UserModel unauthorizedUser;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.unauthorizedUser = this.dataUser.createRandomTestUser();
    }

    @Test(groups={"sanity", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify that valid user can get repositories")
    public void validUserCanGetRepositories() throws Exception {
        Assert.assertNotNull((Object)this.cmisApi.authenticateUser(this.testUser).getSession());
    }

    @Bug(id="REPO-5388")
    @Test(groups={"sanity", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify that valid user with invalid password cannot get repositories")
    public void unauthorizedUserCannotGetRepositories() throws Exception {
        this.unauthorizedUser.setPassword("invalidPass");
        this.cmisApi.authenticateUser(this.unauthorizedUser);
    }

    @Test(groups={"sanity", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify that valid user can get the repository informations")
    public void validUserCanGetRepositoryInfo() throws Exception {
        RepositoryInfo repoInfo = this.cmisApi.authenticateUser(this.testUser).getRepositoryInfo();
        Assert.assertNotNull((Object)repoInfo.getRootFolderId());
        Assert.assertNotNull((Object)repoInfo.getProductVersion());
        Assert.assertNotNull((Object)repoInfo.getRootFolderId());
        Assert.assertNotNull((Object)repoInfo.getId());
        Assert.assertEquals((String)repoInfo.getProductName(), (String)String.format("Alfresco %s", this.serverHealth.getAlfrescoEdition()));
        Assert.assertEquals((String)repoInfo.getVendorName(), (String)"Alfresco");
        RepositoryCapabilities capabilities = repoInfo.getCapabilities();
        Assert.assertNotNull((Object)capabilities);
        Assert.assertEquals((String)capabilities.getContentStreamUpdatesCapability().value(), (String)"anytime", (String)"Verify repository capability: capabilityContentStreamUpdatability");
        Assert.assertEquals((String)capabilities.getRenditionsCapability().value(), (String)"read", (String)"Verify repository capability: capabilityRenditions");
        Assert.assertTrue((boolean)capabilities.isGetDescendantsSupported(), (String)"Verify repository capability: capabilityGetDescendants");
        Assert.assertTrue((boolean)capabilities.isGetFolderTreeSupported(), (String)"Verify repository capability: capabilityGetFolderTree");
        Assert.assertTrue((boolean)capabilities.isMultifilingSupported(), (String)"Verify repository capability: capabilityMultifiling");
        Assert.assertFalse((boolean)capabilities.isUnfilingSupported(), (String)"Verify repository capability: capabilityUnfiling");
        Assert.assertFalse((boolean)capabilities.isVersionSpecificFilingSupported(), (String)"Verify repository capability: capabilityVersionSpecificFiling");
        Assert.assertFalse((boolean)capabilities.isPwcSearchableSupported(), (String)"Verify repository capability: capabilityPWCSearchable");
        Assert.assertTrue((boolean)capabilities.isPwcUpdatableSupported(), (String)"Verify repository capability: capabilityPWCUpdatable");
        Assert.assertFalse((boolean)capabilities.isAllVersionsSearchableSupported(), (String)"Verify repository capability: capabilityAllVersionsSearchable");
        Assert.assertEquals((String)capabilities.getQueryCapability().value(), (String)"bothcombined", (String)"Verify repository capability: capabilityQuery");
        Assert.assertEquals((String)capabilities.getJoinCapability().value(), (String)"none", (String)"Verify repository capability: capabilityJoin");
        Assert.assertEquals((String)capabilities.getAclCapability().value(), (String)"manage", (String)"Verify repository capability: capabilityACL");
    }

    @Test(groups={"sanity", "cmis"})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.SANITY}, description="Verify that valid user can get Acl Capabilities")
    public void validUserCanGetAclCapabilities() throws Exception {
        AclCapabilities aclCapabilities = this.cmisApi.authenticateUser(this.testUser).getAclCapabilities();
        Assert.assertNotNull((Object)aclCapabilities);
        Assert.assertFalse((boolean)aclCapabilities.getPermissions().isEmpty(), (String)"Verify acl capabilities: getPermissions");
        Assert.assertEquals((String)aclCapabilities.getSupportedPermissions().value(), (String)"both", (String)"Verify acl capabilities: getSupportedPermissions");
        Assert.assertEquals((String)aclCapabilities.getAclPropagation().value(), (String)"propagate", (String)"Verify acl capabilities: getAclPropagation");
    }

    @Bug(id="REPO-5388")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that invalid user cannot get repositories")
    public void invalidUserCannotGetRepositories() throws Exception {
        UserModel invalidUser = UserModel.getRandomUserModel();
        this.cmisApi.authenticateUser(invalidUser).getRepositoryInfo();
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisConnectionException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that invalid user cannot get repositories")
    public void userCannotGetRepositoriesUsingWrongBrowserUrl() throws Exception {
        String wrongUrlPath = "//alfresco//api//-default-//public//cmis//versions//1.1";
        this.cmisApi.authUserUsingBrowserUrlAndBindingType(this.testUser, wrongUrlPath, BindingType.BROWSER.value()).getRepositoryInfo();
    }

    @Test(groups={"regression", "cmis"}, expectedExceptions={IllegalArgumentException.class, CmisRuntimeException.class}, expectedExceptionsMessageRegExp="Invalid binding type!")
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that invalid user cannot get repositories")
    public void userCannotGetRepositoriesUsingWrongBindingType() throws Exception {
        String wrongBindingType = BindingType.BROWSER.value() + "w";
        this.cmisApi.authUserUsingBrowserUrlAndBindingType(this.testUser, this.cmisApi.cmisProperties.envProperty().getFullServerUrl() + this.cmisApi.cmisProperties.getBasePath(), wrongBindingType).getRepositoryInfo();
    }

    @Bug(id="REPO-5388")
    @Test(groups={"regression", "cmis"}, expectedExceptions={CmisUnauthorizedException.class})
    @TestRail(section={"cmis-api"}, executionType={ExecutionType.REGRESSION}, description="Verify that disabled user cannot get repositories")
    public void disabledUserCannotGetRepositories() throws Exception {
        UserModel disabledUser = this.dataUser.createRandomTestUser();
        Assert.assertNotNull((Object)this.cmisApi.authenticateUser(disabledUser).getRepositoryInfo());
        ((DataUser)this.dataUser.usingAdmin()).disableUser(disabledUser);
        this.cmisApi.authenticateUser(disabledUser).getRepositoryInfo();
    }
}

