/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.search;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'msuzuki' on '2017-02-21 15:39' from 'Alfresco Search REST API' swagger file 
 * Generated from 'Alfresco Search REST API' swagger file
 * Base Path {@linkplain /alfresco/api/-default-/public/search/versions/1}
 */
public class RestRequestQueryModel extends TestModel implements IRestModel<RestRequestQueryModel>
{
    @JsonProperty(value = "entry")
    RestRequestQueryModel model;

    @Override
    public RestRequestQueryModel onModel()
    {
        return model;
    }

    /**
    The query language in which the query is written.
    */	        

    private String language;	    
    /**
    The exact search request typed in by the user
    */	        

    private String userQuery;	    
    /**
    The query which may have been generated in some way from the userQuery
    */	        

    
    @JsonProperty(required = true)    
    private String query;	    

    public String getLanguage()
    {
        return this.language;
    }

    public void setLanguage(String language)
    {
        this.language = language;
    }				

    public String getUserQuery()
    {
        return this.userQuery;
    }

    public void setUserQuery(String userQuery)
    {
        this.userQuery = userQuery;
    }				

    public String getQuery()
    {
        return this.query;
    }

    public void setQuery(String query)
    {
        this.query = query;
    }
    
}
 
