/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.actions.email;

import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.hamcrest.Matchers;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class EmailTemplateTest
extends RestTest {
    public static final String MAIL_ACTION = "mail";
    private UserModel adminUser;
    private UserModel testUser;
    private FolderModel testFolder;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
        this.testFolder = ((DataContent)this.dataContent.usingUser(this.testUser).usingSite(this.testSite)).createFolder();
    }

    @Test
    public void adminCanSendEmailUsingTemplateWithModelAsString() throws Exception {
        String templateId = this.uploadEmailTemplate("simpleEmailTemplate.ftl");
        JsonObject args = JsonBodyGenerator.defineJSON().add("args", (JsonValue)JsonBodyGenerator.defineJSON().add("name", "testname").build()).build();
        String emailModel = args.toString();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingActions().executeAction(MAIL_ACTION, (RepoTestModel)this.testFolder, EmailTemplateTest.createMailWithTemplateParameters(this.adminUser, this.testUser, templateId, (Serializable)((Object)emailModel)));
        ((ValidatableResponse)((ValidatableResponse)this.restClient.onResponse().assertThat().statusCode(HttpStatus.ACCEPTED.value())).assertThat()).body("entry.id", Matchers.notNullValue(), new Object[0]);
    }

    private String uploadEmailTemplate(String templateName) throws IOException {
        String templateContent = this.getTemplateContent(templateName);
        FileModel templateToCreate = new FileModel(templateName, FileType.TEXT_PLAIN, templateContent);
        FileModel createdTemplate = ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)this.testFolder)).createContent(templateToCreate);
        return createdTemplate.getNodeRef();
    }

    private String getTemplateContent(String templateName) throws IOException {
        String templateClasspathLocation = "/shared-resources/testdata/" + templateName;
        try (InputStream templateStream = ((Object)((Object)this)).getClass().getResourceAsStream(templateClasspathLocation);){
            Objects.requireNonNull(templateStream, "Couldn't locate `" + templateClasspathLocation + "`");
            String string = new String(templateStream.readAllBytes());
            return string;
        }
    }

    private static Map<String, Serializable> createMailWithTemplateParameters(UserModel sender, UserModel recipient, String templateId, Serializable model) {
        HashMap<String, Serializable> parameterValues = new HashMap<String, Serializable>();
        parameterValues.put("from", (Serializable)((Object)sender.getEmailAddress()));
        parameterValues.put("to", (Serializable)((Object)recipient.getEmailAddress()));
        parameterValues.put("subject", (Serializable)((Object)"Test"));
        parameterValues.put("template", (Serializable)((Object)("workspace://SpacesStore/" + templateId)));
        parameterValues.put("template_model", model);
        return parameterValues;
    }
}

