/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.renditions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;

public abstract class RenditionIntegrationTests
extends RestTest {
    protected UserModel user;
    protected SiteModel site;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    protected void checkRendition(String fileName, String nodeId, String renditionId, String expectedMimeType) throws Exception {
        FileModel file = new FileModel();
        file.setNodeRef(nodeId);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)file).deleteNodeRendition(renditionId);
        this.restClient.withCoreAPI().usingNode((RepoTestModel)file).createNodeRendition(renditionId);
        Assert.assertEquals((int)Integer.valueOf(this.restClient.getStatusCode()), (int)HttpStatus.ACCEPTED.value(), (String)("Failed to submit a request for rendition. [" + fileName + ", " + nodeId + ", " + renditionId + "] [source file, node ID, rendition ID]"));
        RestResponse restResponse = this.restClient.withCoreAPI().usingNode((RepoTestModel)file).getNodeRenditionContentUntilIsCreated(renditionId);
        Assert.assertEquals((int)Integer.valueOf(this.restClient.getStatusCode()), (int)HttpStatus.OK.value(), (String)("Failed to produce rendition. [" + fileName + ", " + nodeId + ", " + renditionId + "] [source file, node ID, rendition ID]"));
        Assert.assertEquals((String)this.restClient.getResponseHeaders().getValue("Content-Type"), (String)(expectedMimeType + ";charset=UTF-8"), (String)("Rendition was created but it has the wrong Content-Type. [" + fileName + ", " + nodeId + ", " + renditionId + "] [source file, node ID, rendition ID]"));
        Assert.assertTrue((restResponse.getResponse().body().asInputStream().available() > 0 ? 1 : 0) != 0, (String)("Rendition was created but its content is empty. [" + fileName + ", " + nodeId + ", " + renditionId + "] [source file, node ID, rendition ID]"));
    }

    protected RestNodeModel uploadFile(String sourceFile) throws Exception {
        FolderModel folder = FolderModel.getRandomFolderModel();
        folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder(folder);
        this.restClient.authenticateUser(this.user).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)sourceFile));
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)folder).createNode();
        Assert.assertEquals((int)Integer.valueOf(this.restClient.getStatusCode()), (int)HttpStatus.CREATED.value(), (String)("Failed to created a node for rendition tests using file " + sourceFile));
        return fileNode;
    }
}

