/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TestModel;
import org.alfresco.utility.model.UserModel;

public class JsonBodyGenerator {
    private static JsonBuilderFactory jsonBuilder;

    public static JsonObjectBuilder defineJSON() {
        return JsonBodyGenerator.jsonBuilder().createObjectBuilder();
    }

    public static JsonArrayBuilder defineJSONArray() {
        return JsonBodyGenerator.jsonBuilder().createArrayBuilder();
    }

    public static String keyValueJson(String key, String value) {
        return JsonBodyGenerator.defineJSON().add(key, value).build().toString();
    }

    public static String targetSiteWithGuid(SiteModel siteModel) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("target", JsonBodyGenerator.defineJSON().add("site", JsonBodyGenerator.defineJSON().add("guid", siteModel.getGuid()))).build();
        return value.toString();
    }

    public static String targetFileWithGuid(FileModel fileModel) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("target", JsonBodyGenerator.defineJSON().add("file", JsonBodyGenerator.defineJSON().add("guid", fileModel.getNodeRef().replace(";1.0", "")))).build();
        return value.toString();
    }

    public static String targetFolderWithGuid(FolderModel folderModel) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("target", JsonBodyGenerator.defineJSON().add("folder", JsonBodyGenerator.defineJSON().add("guid", folderModel.getNodeRef()))).build();
        return value.toString();
    }

    private static JsonBuilderFactory jsonBuilder() {
        if (jsonBuilder == null) {
            return Json.createBuilderFactory(null);
        }
        return jsonBuilder;
    }

    public static String likeRating(boolean likeOrNot) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("id", "likes").add("myRating", likeOrNot).build();
        return value.toString();
    }

    public static String fiveStarRating(int stars) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("id", "fiveStar").add("myRating", stars).build();
        return value.toString();
    }

    public static String siteMember(UserModel userModel) {
        Utility.checkObjectIsInitialized((Object)userModel.getUserRole(), (String)"userModel.getUserRole()");
        JsonObject value = JsonBodyGenerator.defineJSON().add("role", userModel.getUserRole().name()).add("id", userModel.getUsername()).build();
        return value.toString();
    }

    public static String siteGroup(String authorityId, UserRole role) {
        Utility.checkObjectIsInitialized((Object)authorityId, (String)"authorityId");
        JsonObject value = JsonBodyGenerator.defineJSON().add("role", role.name()).add("id", authorityId).build();
        return value.toString();
    }

    public static String siteMemberhipRequest(String message, SiteModel siteModel, String title) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("message", message).add("id", siteModel.getId()).add("title", title).build();
        return value.toString();
    }

    public static String updateSiteRequest(SiteModel siteModel) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("title", siteModel.getTitle()).add("description", siteModel.getDescription()).add("visibility", siteModel.getVisibility().toString()).build();
        return value.toString();
    }

    public static String process(String processDefinitionKey, UserModel assignee, boolean sendEmailNotifications, CMISUtil.Priority priority) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("processDefinitionKey", processDefinitionKey).add("variables", JsonBodyGenerator.jsonBuilder().createObjectBuilder().add("bpm_assignee", assignee.getUsername()).add("bpm_sendEMailNotifications", sendEmailNotifications).add("bpm_workflowPriority", priority.getLevel())).build();
        return value.toString();
    }

    public static String processVariable(RestProcessVariableModel variableModel) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("name", variableModel.getName()).add("value", variableModel.getValue()).add("type", variableModel.getType()).build();
        return value.toString();
    }

    public static String taskVariable(RestVariableModel taskVariableModel) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("scope", taskVariableModel.getScope()).add("name", taskVariableModel.getName()).add("type", taskVariableModel.getType()).add("value", taskVariableModel.getValue().toString()).build();
        return value.toString();
    }

    public static String executeActionPostBody(String actionDefinitionId, RepoTestModel targetNode, Map<String, Serializable> params) {
        JsonObjectBuilder objectBuilder = JsonBodyGenerator.jsonBuilder().createObjectBuilder();
        for (Map.Entry<String, Serializable> param : params.entrySet()) {
            JsonBodyGenerator.addJsonValue(objectBuilder, param.getKey(), param.getValue());
        }
        JsonObject value = JsonBodyGenerator.defineJSON().add("actionDefinitionId", actionDefinitionId).add("targetId", targetNode.getNodeRefWithoutVersion()).add("params", objectBuilder).build();
        return value.toString();
    }

    private static void addJsonValue(JsonObjectBuilder objectBuilder, String key, Serializable value) {
        if (value == null) {
            objectBuilder.add(key, JsonObject.NULL);
        } else if (value instanceof Boolean) {
            objectBuilder.add(key, ((Boolean)value).booleanValue());
        } else if (value instanceof String) {
            objectBuilder.add(key, (String)((Object)value));
        } else if (value instanceof Integer) {
            objectBuilder.add(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            objectBuilder.add(key, ((Long)value).longValue());
        } else if (value instanceof Double) {
            objectBuilder.add(key, ((Double)value).doubleValue());
        } else {
            throw new UnsupportedOperationException("Unable to add entry to JsonObject: {" + key + ": " + String.valueOf(value) + "}");
        }
    }

    public static String executeActionPostBody(String actionDefinitionId, RepoTestModel targetNode) {
        JsonObject value = JsonBodyGenerator.defineJSON().add("actionDefinitionId", actionDefinitionId).add("targetId", targetNode.getNodeRefWithoutVersion()).build();
        return value.toString();
    }

    public static String keyValueJson(HashMap<String, String> mapJson) {
        JsonObjectBuilder builder = JsonBodyGenerator.defineJSON();
        for (Map.Entry<String, String> entry : mapJson.entrySet()) {
            builder.add(entry.getKey().toString(), entry.getValue().toString());
        }
        return builder.build().toString();
    }

    public static String arrayToJson(List<? extends TestModel> models) {
        StringJoiner stringJoiner = new StringJoiner(",\n");
        for (TestModel testModel : models) {
            stringJoiner.add(testModel.toJson());
        }
        return "[\n" + stringJoiner.toString() + "\n]";
    }
}

