/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.search;

import io.restassured.RestAssured;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.rest.search.SearchSqlRequest;
import org.springframework.http.HttpMethod;

public class SearchSQLAPI
extends ModelRequest<SearchSQLAPI> {
    public SearchSQLAPI(RestWrapper restWrapper) {
        super(restWrapper);
        restWrapper.configureAlfrescoEndpoint();
        RestAssured.basePath = "alfresco/api/-default-/public/search/versions/1";
        restWrapper.configureRequestSpec().setBasePath(RestAssured.basePath);
    }

    public RestResponse searchSql(SearchSqlRequest query) {
        String stmt = null == query.getSql() || query.getSql().isEmpty() ? "" : query.getSql();
        String format = null == query.getFormat() || query.getFormat().isEmpty() ? "" : query.getFormat();
        JsonArrayBuilder array = JsonBodyGenerator.defineJSONArray();
        if (query.getLocales() != null) {
            for (String locale : query.getLocales()) {
                array.add(locale);
            }
        }
        String timezone = null == query.getTimezone() || query.getTimezone().isEmpty() ? "" : query.getTimezone();
        Boolean includeMetadata = query.getIncludeMetadata() != null && query.getIncludeMetadata() != false;
        Integer limit = null == query.getLimit() ? 0 : query.getLimit();
        JsonArrayBuilder filterQueries = null;
        if (query.getFilterQueries() != null) {
            filterQueries = JsonBodyGenerator.defineJSONArray();
            for (String filterQuery : query.getFilterQueries()) {
                filterQueries.add(filterQuery);
            }
        }
        JsonObjectBuilder builder = JsonBodyGenerator.defineJSON().add("stmt", stmt).add("format", format).add("locales", array).add("timezone", timezone).add("includeMetadata", includeMetadata.booleanValue()).add("limit", limit.intValue());
        if (filterQueries != null) {
            builder.add("filterQueries", filterQueries);
        }
        String postBody = builder.build().toString();
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "sql", new String[0]);
        return this.restWrapper.process(request);
    }
}

