/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.syncServiceAPI;

import io.restassured.http.ContentType;
import java.util.List;
import javax.json.JsonArrayBuilder;
import javax.json.JsonValue;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestSyncNodeSubscriptionModel;
import org.alfresco.rest.model.RestSyncSetChangesModel;
import org.alfresco.rest.model.RestSyncSetGetModel;
import org.alfresco.rest.model.RestSyncSetRequestModel;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.rest.requests.privateAPI.RestPrivateAPI;
import org.alfresco.utility.Utility;
import org.springframework.http.HttpMethod;

public class Sync
extends ModelRequest<RestPrivateAPI> {
    String subscriber;
    RestSyncNodeSubscriptionModel subscription;
    String requestSyncURL = "subscribers/{deviceSubscriptionId}/subscriptions/{nodeSubscriptionId}/sync";
    String syncSetURL = this.requestSyncURL + "/{syncId}";

    public Sync(RestSyncNodeSubscriptionModel subscription, RestWrapper restWrapper) {
        super(restWrapper);
        restWrapper.configureSyncServiceEndPoint();
        this.subscription = subscription;
        this.subscriber = subscription.getDeviceSubscriptionId();
        Utility.checkObjectIsInitialized((Object)this.subscription, (String)"Node Subscription");
    }

    public RestSyncSetRequestModel startSync(RestSyncNodeSubscriptionModel nodeSubscriptionModel, List<RestSyncSetChangesModel> clientChanges, String clientVersion) {
        JsonArrayBuilder array = JsonBodyGenerator.defineJSONArray();
        for (RestSyncSetChangesModel change : clientChanges) {
            array.add(JsonBodyGenerator.defineJSON().add("changes", change.toJson()));
        }
        String postBody = JsonBodyGenerator.defineJSON().add("changes", (JsonValue)array.build()).add("clientVersion", clientVersion).build().toString();
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, this.requestSyncURL, this.subscriber, nodeSubscriptionModel.getId(), this.restWrapper.getParameters());
        this.restWrapper.configureRequestSpec().setContentType(ContentType.JSON.withCharset(request.getContentType()));
        RestSyncSetRequestModel model = this.restWrapper.processModelWithoutEntryObject(RestSyncSetRequestModel.class, request);
        this.restWrapper.initializeRequestSpecBuilder();
        return model;
    }

    public RestWrapper endSync(RestSyncNodeSubscriptionModel nodeSubscriptionModel, RestSyncSetRequestModel sync) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, this.syncSetURL, this.subscriber, nodeSubscriptionModel.getId(), sync.getSyncId(), this.restWrapper.getParameters());
        this.restWrapper.processEmptyModel(request);
        this.restWrapper.initializeRequestSpecBuilder();
        return this.restWrapper;
    }

    public RestSyncSetGetModel getSync(RestSyncNodeSubscriptionModel nodeSubscriptionModel, RestSyncSetRequestModel sync) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, this.syncSetURL, this.subscriber, nodeSubscriptionModel.getId(), sync.getSyncId(), this.restWrapper.getParameters());
        RestSyncSetGetModel model = this.restWrapper.processModelWithoutEntryObject(RestSyncSetGetModel.class, request);
        this.restWrapper.initializeRequestSpecBuilder();
        return model;
    }
}

