/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.actions.access;

import io.restassured.response.ValidatableResponse;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.actions.access.AccessRestrictionUtil;
import org.alfresco.rest.actions.access.pojo.Action;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.UserModel;
import org.hamcrest.Matchers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class V0AdminAccessRestrictionTest
extends RestTest {
    private static final String ACTION_QUEUE_ENDPOINT = "alfresco/service/api/actionQueue?async=false";
    private UserModel adminUser;
    private UserModel testUser;
    @Autowired
    protected RestWrapper restClient;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingUser(this.testUser)).createPublicRandomSite();
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.restClient.configureRequestSpec().setBasePath("");
    }

    @Test
    public void userShouldNotExecuteMailActionQueue() {
        this.restClient.authenticateUser(this.testUser);
        Action action = AccessRestrictionUtil.createActionWithParameters("mail", AccessRestrictionUtil.createMailParameters(this.adminUser, this.testUser));
        String actionRequestBody = AccessRestrictionUtil.mapObjectToJSON(action);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)actionRequestBody, (String)ACTION_QUEUE_ENDPOINT, (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        ((ValidatableResponse)((ValidatableResponse)response.assertThat().statusCode(HttpStatus.INTERNAL_SERVER_ERROR.value())).assertThat()).body("message", Matchers.containsString((String)"Only admin or system user is allowed to define uses of or directly execute this action"), new Object[0]);
    }

    @Test
    public void adminShouldExecuteMailActionQueue() {
        this.restClient.authenticateUser(this.adminUser);
        Action action = AccessRestrictionUtil.createActionWithParameters("mail", AccessRestrictionUtil.createMailParameters(this.adminUser, this.testUser));
        String actionRequestBody = AccessRestrictionUtil.mapObjectToJSON(action);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)actionRequestBody, (String)ACTION_QUEUE_ENDPOINT, (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        ((ValidatableResponse)((ValidatableResponse)response.assertThat().statusCode(HttpStatus.INTERNAL_SERVER_ERROR.value())).assertThat()).body("message", Matchers.containsString((String)AccessRestrictionUtil.getExpectedEmailSendFailureMessage(this.testUser)), new Object[0]);
    }
}

