/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.membershipRequests;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.rest.model.RestSiteMemberModelsCollection;
import org.alfresco.rest.model.RestSiteMembershipRequestModel;
import org.alfresco.rest.model.RestSiteMembershipRequestModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestSitePersonMembershipRequestModel;
import org.alfresco.rest.model.RestSitePersonMembershipRequestModelsCollection;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteMembershipRequestsTests
extends RestTest {
    UserModel siteManager;
    UserModel newMember;
    UserModel adminUser;
    UserModel regularUser;
    UserModel testUser;
    UserModel testUser1;
    DataUser.ListUserWithRoles usersWithRoles;
    SiteModel moderatedSite1;
    SiteModel moderatedSite2;
    RestSiteMembershipRequestModelsCollection siteMembershipRequests;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.siteManager = this.dataUser.createRandomTestUser();
        this.newMember = this.dataUser.createRandomTestUser();
        this.regularUser = this.dataUser.createRandomTestUser();
        this.testUser = this.dataUser.createRandomTestUser("testUser");
        this.testUser.setUserRole(UserRole.SiteConsumer);
        this.testUser1 = this.dataUser.createRandomTestUser("testUser1");
        this.testUser1.setUserRole(UserRole.SiteConsumer);
        this.moderatedSite1 = ((DataSite)this.dataSite.usingUser(this.siteManager)).createModeratedRandomSite();
        this.moderatedSite2 = ((DataSite)this.dataSite.usingUser(this.siteManager)).createModeratedRandomSite();
        this.restClient.authenticateUser(this.newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.moderatedSite1, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @Bug(id="MNT-16557")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify manager user gets all site membership requests of a specific person with Rest API and response is successful (200)")
    public void managerUserGetsSiteMembershipRequestsWithSuccess() throws Exception {
        this.siteMembershipRequests = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @Bug(id="MNT-16557")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator user fails to get all site membership requests of another user with Rest API (403)")
    public void collaboratorUserFailsToGetSiteMembershipRequestsOfAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @Bug(id="MNT-16557")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user fails to get all site membership requests of another user with Rest API (403)")
    public void contributorUserFailsToGetSiteMembershipRequestsOfAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @Bug(id="MNT-16557")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer user fails to get all site membership requests of another user with Rest API (403)")
    public void consumerUserFailsToGetSiteMembershipRequestsOfAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @Bug(id="MNT-16557")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user gets all site membership requests of a specific person with Rest API and response is successful (200)")
    public void adminGetsSiteMembershipRequestsOfanotherUserWithSuccess() throws Exception {
        this.siteMembershipRequests = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify manager user fails to get all site membership requests of a specific person with Rest API when the authentication fails (401)")
    public void unauthorizedUserFailsToGetSiteMembershipRequests() throws Exception {
        this.restClient.authenticateUser(new UserModel("random user", "random password")).withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify a user gets all its own site membership requests with Rest API and response is successful (200)")
    public void oneUserGetsItsOwnSiteMembershipRequestsWithSuccess() throws Exception {
        this.siteMembershipRequests = this.restClient.authenticateUser(this.newMember).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.siteMembershipRequests.assertThat().entriesListContains("id", this.moderatedSite1.getId())).assertThat().entriesListContains("message", "Please accept me")).assertThat().entriesListCountIs(2);
        RestSiteModel firstSite = ((RestSiteMembershipRequestModel)this.siteMembershipRequests.getEntries().get(0)).onModel().getSite();
        if (firstSite.getId().equals(this.moderatedSite1.getId())) {
            ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)firstSite.assertThat().field("visibility").is((Object)this.moderatedSite1.getVisibility())).assertThat().field("guid").is((Object)this.moderatedSite1.getGuid())).assertThat().field("description").is((Object)this.moderatedSite1.getDescription())).assertThat().field("id").is((Object)this.moderatedSite1.getId())).assertThat().field("title").is((Object)this.moderatedSite1.getTitle());
        } else {
            ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)firstSite.assertThat().field("visibility").is((Object)this.moderatedSite2.getVisibility())).assertThat().field("guid").is((Object)this.moderatedSite2.getGuid())).assertThat().field("description").is((Object)this.moderatedSite2.getDescription())).assertThat().field("id").is((Object)this.moderatedSite2.getId())).assertThat().field("title").is((Object)this.moderatedSite2.getTitle());
        }
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that for invalid maxItems parameter status code returned is 400.")
    @Test(groups={"rest-api", "people", "regression"})
    public void checkInvalidMaxItemsStatusCode() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=AB"}).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "AB"));
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=0"}).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that for invalid skipCount parameter status code returned is 400.")
    @Test(groups={"rest-api", "people", "regression"})
    public void checkInvalidSkipCountStatusCode() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"skipCount=AB"}).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "AB"));
        this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"skipCount=-1"}).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that if personId does not exist status code returned is 404.")
    @Test(groups={"rest-api", "people", "regression"})
    public void ifPersonIdDoesNotExist() throws Exception {
        UserModel nonexistentUser = this.dataUser.createRandomTestUser();
        nonexistentUser.setUsername("nonexistent");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(nonexistentUser).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "nonexistent")).statusCodeIs(HttpStatus.NOT_FOUND).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Specify -me- string in place of <personid> for request.")
    @Test(groups={"rest-api", "people", "regression"})
    public void replacePersonIdWithMeRequest() throws Exception {
        UserModel meUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(meUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite1);
        this.siteMembershipRequests = this.restClient.authenticateUser(meUser).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListContains("id", this.moderatedSite1.getId());
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that if empty personId is used status code returned is 404.")
    @Test(groups={"rest-api", "people", "regression"})
    public void useEmptyPersonId() throws Exception {
        UserModel emptyNameMember = this.dataUser.createRandomTestUser();
        emptyNameMember.setUsername(" ");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(emptyNameMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, emptyNameMember.getUsername()));
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Get site membership requests to a public site.")
    @Test(groups={"rest-api", "people", "regression"})
    public void getRequestsToPublicSite() throws Exception {
        SiteModel publicSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.restClient.authenticateUser(this.newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.siteMembershipRequests = this.restClient.withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListDoesNotContain("id", publicSite.getId());
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Approve request then get requests.")
    @Test(groups={"rest-api", "people", "regression"})
    public void approveRequestThenGetRequests() throws Exception {
        UserModel siteManager = this.dataUser.createRandomTestUser();
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(siteManager)).createModeratedRandomSite();
        this.restClient.authenticateUser(this.newMember).withCoreAPI().usingMe().addSiteMembershipRequest(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(this.newMember).withWorkflowAPI().getTasks().getTaskModelByDescription(moderatedSite);
        this.workflow.approveSiteMembershipRequest(siteManager.getUsername(), siteManager.getPassword(), taskModel.getId(), true, "Approve");
        this.siteMembershipRequests = this.restClient.authenticateUser(this.newMember).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListDoesNotContain("id", moderatedSite.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user gets all its own site membership requests with Rest API and response is successful (200)")
    public void adminGetsItsOwnSiteMembershipRequestsWithSuccess() throws Exception {
        this.siteMembershipRequests = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.siteMembershipRequests.assertThat().entriesListContains("id", this.moderatedSite1.getId())).assertThat().entriesListContains("id", this.moderatedSite2.getId());
    }

    @Bug(id="MNT-16557")
    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user fails to get all site membership requests of another user with Rest API (403)")
    public void regularUserFailsToGetSiteMembershipRequestsOfAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Bug(id="MNT-16557")
    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user fails to get all site membership requests of admin with Rest API (403)")
    public void regularUserFailsToGetSiteMembershipRequestsOfAdmin() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(this.adminUser).getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user is able to get his site membership requests with, but skip the first one")
    public void getSiteMembershipRequestsButSkipTheFirstOne() throws Exception {
        this.siteMembershipRequests = this.restClient.authenticateUser(this.newMember).withParams(new String[]{"orderBy=id ASC"}).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.siteMembershipRequests.assertThat().entriesListContains("id", this.moderatedSite1.getId())).assertThat().entriesListContains("id", this.moderatedSite2.getId());
        RestSiteMembershipRequestModel firstSiteMembershipRequest = ((RestSiteMembershipRequestModel)this.siteMembershipRequests.getEntries().get(0)).onModel();
        RestSiteMembershipRequestModel secondSiteMembershipRequest = ((RestSiteMembershipRequestModel)this.siteMembershipRequests.getEntries().get(1)).onModel();
        this.siteMembershipRequests = this.restClient.authenticateUser(this.newMember).withParams(new String[]{"orderBy=id ASC&skipCount=1"}).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.siteMembershipRequests.assertThat().entriesListDoesNotContain("id", firstSiteMembershipRequest.getId())).assertThat().entriesListContains("id", secondSiteMembershipRequest.getId())).assertThat().entriesListContains("id", secondSiteMembershipRequest.getSite().getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user is able to get his site membership requests with higher skipCount than number of requests")
    public void getSiteMembershipRequestsWithHighSkipCount() throws Exception {
        this.siteMembershipRequests = this.restClient.authenticateUser(this.newMember).withParams(new String[]{"skipCount=3"}).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify get site membership requests returns an empty list where there are no requests")
    public void getSiteMembershipRequestsWhereThereAreNoRequests() throws Exception {
        this.siteMembershipRequests = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Reject request then get site membership requests.")
    public void rejectRequestThenGetSiteMembershipRequests() throws Exception {
        UserModel userWithRejectedRequests = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userWithRejectedRequests).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite1);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(userWithRejectedRequests).withWorkflowAPI().getTasks().getTaskModelByDescription(this.moderatedSite1);
        this.workflow.approveSiteMembershipRequest(this.siteManager.getUsername(), this.siteManager.getPassword(), taskModel.getId(), false, "Rejected");
        this.siteMembershipRequests = this.restClient.authenticateUser(userWithRejectedRequests).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.siteMembershipRequests.assertThat().entriesListDoesNotContain("id", this.moderatedSite1.getId())).assertThat().entriesListContains("id", this.moderatedSite2.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Check get site membership requests when properties parameter is used")
    public void getSiteMembershipRequestsWithProperties() throws Exception {
        this.siteMembershipRequests = this.restClient.authenticateUser(this.newMember).withParams(new String[]{"properties=id"}).withCoreAPI().usingAuthUser().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.siteMembershipRequests.assertThat().entriesListContains("id", this.moderatedSite1.getId())).assertThat().entriesListContains("id", this.moderatedSite2.getId());
        RestSiteMembershipRequestModel siteMembershipRequest = ((RestSiteMembershipRequestModel)this.siteMembershipRequests.getOneRandomEntry()).onModel();
        siteMembershipRequest.assertThat().fieldsCount().is((Object)1);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Sanity test for endpoints: GET /site-membership-requests, POST /sites/{siteId}/site-membership-requests/{inviteeId}/approve, POST /sites/{siteId}/site-membership-requests/{inviteeId}/reject")
    public void approveRejectSiteMembership() throws Exception {
        Step.STEP((String)"1. Make membership requests for 2 users on moderatedSite.");
        this.restClient.authenticateUser(this.testUser).withCoreAPI().usingMe().addSiteMembershipRequest(this.moderatedSite1);
        this.restClient.authenticateUser(this.testUser1).withCoreAPI().usingMe().addSiteMembershipRequest(this.moderatedSite1);
        Step.STEP((String)"2. Get site memberships and filter using username and siteId ");
        RestSitePersonMembershipRequestModelsCollection membership = this.restClient.authenticateUser(this.siteManager).withParams(new String[]{"where=(personId='" + this.testUser.getUsername() + "' AND siteId='" + this.moderatedSite1.getId() + "')"}).withCoreAPI().usingSite(this.moderatedSite1).getSiteMemberships();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSitePersonMembershipRequestModel)membership.getEntryByIndex(0)).getSite().assertThat().field("id").is((Object)this.moderatedSite1.getId());
        ((RestSitePersonMembershipRequestModel)membership.getEntryByIndex(0)).getPersonModel().assertThat().field("id").is((Object)this.testUser.getUsername());
        Step.STEP((String)"3. Approve site membership for one of the users. Check that the user is now a member of the site");
        this.restClient.authenticateUser(this.siteManager).withCoreAPI().usingSite(this.moderatedSite1).approveSiteMembership(this.testUser);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMemberModel)this.restClient.withCoreAPI().usingSite(this.moderatedSite1).getSiteMember(this.testUser).assertThat().field("id").is((Object)this.testUser.getUsername())).and().field("role").is((Object)this.testUser.getUserRole());
        Step.STEP((String)"4. Reject site membership for the second user. Check that the user is not a member of the site");
        this.restClient.authenticateUser(this.siteManager).withCoreAPI().usingSite(this.moderatedSite1).rejectSiteMembership(this.testUser1);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestSiteMemberModelsCollection memberList = this.restClient.withCoreAPI().usingSite(this.moderatedSite1).getSiteMembers();
        memberList.assertThat().entriesListDoesNotContain("id", this.testUser1.getUsername());
    }
}

