/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.comments;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestCommentModelsCollection;
import org.alfresco.rest.model.RestCompanyModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestPersonModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.LinkModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetCommentsTests
extends RestTest {
    private FileModel file;
    private FileModel document;
    private FileModel document1;
    private SiteModel siteModel;
    private SiteModel privateSiteModel;
    private UserModel adminUserModel;
    private UserModel userModel;
    private UserModel networkUserModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private String comment = "This is a new comment";
    private String comment2 = "This is a 2nd comment";
    private String comment3 = "This is a 3rd comment";
    private RestCommentModelsCollection comments;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.networkUserModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPrivateRandomSite();
        this.document = ((DataContent)this.dataContent.usingSite(this.privateSiteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.document1 = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document1).addComment(this.comment);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment(this.comment2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment(this.comment3);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify Admin user gets comments with Rest API and status code is 200")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void adminIsAbleToRetrieveComments() throws Exception {
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document1).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", this.comment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify Manager user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void managerIsNotAbleToRetrieveCommentIfAuthenticationFails() throws Exception {
        UserModel nonexistentModel = new UserModel("nonexistentUser", "nonexistentPassword");
        this.restClient.authenticateUser(nonexistentModel).withCoreAPI().usingResource((RepoTestModel)this.document1).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user gets comments created by admin user with Rest API and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToRetrieveComments() throws Exception {
        this.comments = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.document1).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", this.comment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user gets comments created by admin user with Rest API and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void contributorIsAbleToRetrieveComments() throws Exception {
        this.comments = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)this.document1).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", this.comment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user gets comments created by admin user with Rest API and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void collaboratorIsAbleToRetrieveComments() throws Exception {
        this.comments = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.document1).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", this.comment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user gets comments created by admin user with Rest API and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void consumerIsAbleToRetrieveComments() throws Exception {
        this.comments = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)this.document1).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", this.comment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user gets comments created by another user and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToRetrieveCommentsCreatedByAnotherUser() throws Exception {
        this.userModel = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        String contentManager = "This is a new comment added by " + this.userModel.getUsername();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingResource((RepoTestModel)this.document1).addComment(contentManager);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.document1).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.comments.assertThat().entriesListContains("content", contentManager)).and().entriesListContains("content", this.comment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user gets comments created by another user and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void adminIsAbleToRetrieveCommentsCreatedByAnotherUser() throws Exception {
        this.userModel = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        String contentCollaborator = "This is a new comment added by " + this.userModel.getUsername();
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingResource((RepoTestModel)this.document1).addComment(contentCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document1).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.comments.assertThat().entriesListContains("content", contentCollaborator)).and().entriesListContains("content", this.comment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify request returns status 403 if the user does not have permission read comments on the node")
    @Test(groups={"rest-api", "comments", "regression"})
    public void uninvitedUserCanNotGetCommentsFromPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets comments without the first 2 and status code is 200")
    @Test(groups={"rest-api", "comments", "regression"})
    public void skipFirst2Comments() throws Exception {
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"skipCount=2"}).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.comments.assertThat().entriesListContains("content", this.comment)).and().paginationField("count").is("1");
        this.comments.assertThat().paginationField("skipCount").is("2");
        this.comments.assertThat().paginationField("totalItems").is("3");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify invalid request returns status code 400 for invalid maxItems or skipCount")
    @Test(groups={"rest-api", "comments", "regression"})
    public void checkStatusCodeForInvalidMaxItems() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"maxItems=0"}).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Only positive values supported for maxItems");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify User can't get comments for node with ID that does not exist and status code is 404")
    @Test(groups={"rest-api", "comments", "regression"})
    public void userCanNotGetCommentsOnNonExistentFile() throws Exception {
        FileModel nonexistentFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        nonexistentFile.setNodeRef("ABC");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)nonexistentFile).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, nonexistentFile.getNodeRef()));
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify User can't get comments for node that exists but is not a document or a folder and status code is 400")
    @Test(groups={"rest-api", "comments", "regression"})
    public void userCanNotGetCommentsOnLink() throws Exception {
        LinkModel link = ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.siteModel)).createRandomLink();
        FileModel fileWithNodeRefFromLink = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        fileWithNodeRefFromLink.setNodeRef(link.getNodeRef().replace("workspace://SpacesStore/", "workspace%3A%2F%2FSpacesStore%2F"));
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)fileWithNodeRefFromLink).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, fileWithNodeRefFromLink.getNodeRef())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify get comments from node with invalid network id returns status code 401")
    @Test(groups={"rest-api", "comments", "regression"})
    public void getCommentsWithInvalidNetwork() throws Exception {
        this.networkUserModel.setDomain("invalidNetwork");
        this.restClient.authenticateUser(this.networkUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify get comments from node with empty network id returns status code 401")
    @Test(groups={"rest-api", "comments", "regression"})
    public void getCommentsWithEmptyNetwork() throws Exception {
        this.networkUserModel.setDomain("");
        this.restClient.authenticateUser(this.networkUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that if manager adds one comment, it will be returned in getComments response")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentWithManagerAndCheckThatCommentIsReturned() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestModels)this.comments.assertThat().entriesListContains("content", this.comment)).getPagination().assertThat().field("totalItems").is((Object)"1")).assertThat().field("count").is((Object)"1");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that if collaborator adds one comment, it will be returned in getComments response")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentWithCollaboratorAndCheckThatCommentIsReturned() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestModels)this.comments.assertThat().entriesListContains("content", this.comment)).getPagination().assertThat().field("totalItems").is((Object)"1")).assertThat().field("count").is((Object)"1");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that if contributor adds one comment, it will be returned in getComments response")
    @Test(groups={"rest-api", "comments", "regression"})
    @Bug(id="ACE-4614")
    public void addCommentWithContributorAndCheckThatCommentIsReturned() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)((RestModels)this.comments.assertThat().entriesListContains("content", this.comment)).getPagination().assertThat().field("totalItems").is((Object)"1")).assertThat().field("count").is((Object)"1");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that consumer cannot add a comment and no comments will be returned in getComments response")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentWithConsumerAndCheckThatCommentIsNotReturned() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().paginationField("totalItems").is("0");
        this.comments.assertThat().paginationField("count").is("0");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Add one comment with Manager and check that returned person is the right one")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentWithManagerCheckReturnedPersonIsTheRightOne() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        UserModel user1 = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(user1, this.siteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(user1).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        ((RestPersonModel)((RestCommentModel)this.comments.getOneRandomEntry()).onModel().getCreatedBy().assertThat().field("firstName").is((Object)("FN-" + user1.getUsername()))).assertThat().field("lastName").is((Object)("LN-" + user1.getUsername()));
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Add one comment with Collaborator and check that returned company details are correct")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentWithCollaboratorCheckReturnedCompanyDetails() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        ((RestCompanyModel)((RestCompanyModel)((RestCompanyModel)((RestCompanyModel)((RestCompanyModel)((RestCompanyModel)((RestCompanyModel)((RestCommentModel)this.comments.getOneRandomEntry()).onModel().getCreatedBy().getCompany().assertThat().field("organization").isNull()).assertThat().field("address1").isNull()).assertThat().field("address2").isNull()).assertThat().field("address3").isNull()).assertThat().field("postcode").isNull()).assertThat().field("telephone").isNull()).assertThat().field("fax").isNull()).assertThat().field("email").isNull();
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Add 2 comments with Manager and Collaborator users and verify valid request using skipCount. Check that param is applied")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addTwoCommentsWithManagerCollaboratorVerifySkipCountParamIsApplied() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment2);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"skipCount=1"}).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.comments.assertThat().entriesListContains("content", this.comment)).and().paginationField("count").is("1");
        this.comments.assertThat().paginationField("skipCount").is("1");
        this.comments.assertThat().paginationField("totalItems").is("2");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Add 2 comments with Admin and Collaborator users and verify valid request using maxItems. Check that param is applied")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addTwoCommentsWithAdminCollaboratorVerifyMaxItemsParamIsApplied() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment2);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"maxItems=1"}).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.comments.assertThat().entriesListContains("content", this.comment2)).and().paginationField("count").is("1");
        this.comments.assertThat().paginationField("totalItems").is("2");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Add 2 comments with Manager and Admin users and verify valid request using properties. Check that param is applied")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addTwoCommentsWithAdminManagerVerifyPropertiesParamIsApplied() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.file).addComment(this.comment2);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"properties=createdBy,modifiedBy"}).withCoreAPI().usingResource((RepoTestModel)this.file).getNodeComments();
        ((RestModels)this.comments.assertThat().entriesListIsNotEmpty()).and().paginationField("count").is("2");
        this.comments.assertThat().paginationField("totalItems").is("2");
        ((RestPersonModel)((RestCommentModel)this.comments.getEntries().get(0)).onModel().getCreatedBy().assertThat().field("firstName").is((Object)("FN-" + this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager).getUsername()))).assertThat().field("lastName").is((Object)("LN-" + this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager).getUsername()));
        ((RestPersonModel)((RestCommentModel)this.comments.getEntries().get(1)).onModel().getCreatedBy().assertThat().field("firstName").is((Object)"Administrator")).assertThat().field("id").is((Object)"admin");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Check default error model schema")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addTwoCommentsWithManagerCheckDefaultErrorModelSchema() throws Exception {
        this.file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.file).addComments(new String[]{this.comment, this.comment2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((Node)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.file).usingParams(new String[]{"maxItems=0"})).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
        this.restClient.assertLastError().containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
        this.restClient.assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
        this.restClient.assertLastError().descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
        this.restClient.assertLastError().stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

