/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.misc;

import io.restassured.RestAssured;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.utility.model.UserModel;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class CORSTest
extends RestTest {
    @Test(groups={"rest-api", "sanity", "core"})
    public void assertCORSisEnabledAndWorking() {
        String validOriginUrl = "http://localhost:4200";
        String invalidOriginUrl1 = "http://localhost:4201";
        String invalidOriginUrl2 = "http://example.com";
        RestAssured.basePath = "alfresco/api/-default-/public/authentication/versions/1";
        this.restClient.configureRequestSpec().setBasePath(RestAssured.basePath);
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.OPTIONS, (String)"tickets", (String[])new String[0]);
        this.restClient.configureRequestSpec().addHeader("Origin", validOriginUrl);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
        this.restClient.configureRequestSpec().addHeader("Access-Control-Request-Method", "PATCH");
        this.restClient.configureRequestSpec().addHeader("Origin", validOriginUrl);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.configureRequestSpec().addHeader("Access-Control-Request-Method", "invalid");
        this.restClient.configureRequestSpec().addHeader("Origin", validOriginUrl);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.configureRequestSpec().addHeader("Access-Control-Request-Method", "POST");
        this.restClient.configureRequestSpec().addHeader("Origin", invalidOriginUrl1);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.configureRequestSpec().addHeader("Origin", invalidOriginUrl2);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.configureRequestSpec().addHeader("Access-Control-Request-Method", "POST");
        this.restClient.configureRequestSpec().addHeader("Origin", validOriginUrl);
        this.restClient.process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Access-Control-Allow-Origin", validOriginUrl);
        this.restClient.assertHeaderValueContains("Access-Control-Allow-Credentials", "true");
        this.restClient.assertHeaderValueContains("Access-Control-Max-Age", "10");
        this.restClient.assertHeaderValueContains("Access-Control-Allow-Methods", "POST");
    }

    @Test(groups={"rest-api", "sanity", "core"})
    public void assertCORSisEnabledAndWorkingForDiscovery() {
        String validOriginUrl = "http://localhost:4200";
        RestAssured.basePath = "alfresco/api";
        this.restClient.configureRequestSpec().setBasePath(RestAssured.basePath);
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"discovery", (String[])new String[0]);
        this.restClient.configureRequestSpec().addHeader("Access-Control-Request-Method", "GET");
        this.restClient.configureRequestSpec().addHeader("Origin", validOriginUrl);
        UserModel userModel = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userModel).process(request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.assertHeaderValueContains("Access-Control-Allow-Origin", validOriginUrl);
        this.restClient.assertHeaderValueContains("Access-Control-Allow-Credentials", "true");
        this.restClient.assertHeaderValueContains("Access-Control-Expose-Headers", "Access-Control-Allow-Origin,Access-Control-Allow-Credentials");
    }
}

