/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.model.RestRuleSetLinkModel;
import org.alfresco.rest.model.RestRuleSetModel;
import org.alfresco.rest.model.RestRuleSetModelsCollection;
import org.alfresco.rest.model.RestRuleSettingsModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.rest.requests.privateAPI.RestPrivateAPI;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.junit.Assert;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class GetRuleSetsTests
extends RulesRestTest {
    private UserModel user;
    private SiteModel site;
    private FolderModel ruleFolder;
    private FolderModel privateFolder;
    private FolderModel inheritingChildFolder;
    private FolderModel notInheritingChildFolder;
    private RestRuleModel rule;
    private String ruleSetId;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create a user, site and folder.");
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        this.ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Create two children of the folder - one that inherits rules and one that doesn't");
        this.inheritingChildFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)this.ruleFolder)).createFolder();
        this.notInheritingChildFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)this.ruleFolder)).createFolder();
        RestRuleSettingsModel doesntInherit = new RestRuleSettingsModel();
        doesntInherit.setValue((Object)false);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.notInheritingChildFolder).usingIsInheritanceEnabledRuleSetting().updateSetting(doesntInherit);
        Step.STEP((String)"Create a rule in the folder.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("ruleName");
        this.rule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Get the rule sets for the folder and find the rule set id");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).getListOfRuleSets();
        ruleSets.assertThat().entriesListCountIs(1);
        this.ruleSetId = ((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().getId();
        Step.STEP((String)"Use admin to create a private site containing a rule in a rule set that can be inherited.");
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        this.privateAPIForAdmin().usingNode((RepoTestModel)this.privateFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithModifiedValues());
    }

    @Test(groups={"rest-api", "rules"})
    public void getEmptyRuleSetsList() {
        Step.STEP((String)"Create a folder in existing site");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Get the rule sets for the folder");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folder).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertTrue((String)"Expected no rule sets to be present.", (boolean)ruleSets.isEmpty());
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getRuleSetsList() {
        Step.STEP((String)"Get the rule sets for the folder");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSets.assertThat().entriesListCountIs(1);
        ((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().assertThat().field("id").isNotNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetsForNonExistentFolder() {
        Step.STEP((String)"Try to load rule sets for a non-existent folder.");
        FolderModel nonExistentFolder = FolderModel.getRandomFolderModel();
        nonExistentFolder.setNodeRef("fake-id");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)nonExistentFolder).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetsWithoutPermission() {
        Step.STEP((String)"Check a user cannot list rule sets without read access.");
        this.privateAPIForUser().usingNode((RepoTestModel)this.privateFolder).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "rules"})
    public void permissionsAreRespectedWhenListingRuleSets() {
        Step.STEP((String)"Create a public site containing a parent and child folder with rule inheritance enabled.");
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        FolderModel parentFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(publicSite)).createFolder();
        FolderModel childFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)parentFolder)).createFolder();
        RestRuleSettingsModel enabled = new RestRuleSettingsModel();
        enabled.setValue((Object)true);
        this.privateAPIForUser().usingNode((RepoTestModel)parentFolder).usingRuleSetting("-isInheritanceEnabled-").updateSetting(enabled);
        Step.STEP((String)"Link the parent folder to a private rule set.");
        RestRuleSetLinkModel linkModel = new RestRuleSetLinkModel();
        linkModel.setId(this.privateFolder.getNodeRef());
        this.privateAPIForAdmin().usingNode((RepoTestModel)parentFolder).createRuleLink(linkModel);
        Step.STEP((String)"Create a rule on the child folder.");
        this.privateAPIForUser().usingNode((RepoTestModel)childFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        Step.STEP((String)"Check admin can view both rule sets.");
        RestRuleSetModelsCollection adminViewOfRuleSets = this.privateAPIForAdmin().usingNode((RepoTestModel)childFolder).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestRuleSetModel parentRuleSet = ((RestRuleSetModel)adminViewOfRuleSets.getEntries().get(0)).onModel();
        RestRuleSetModel childRuleSet = ((RestRuleSetModel)adminViewOfRuleSets.getEntries().get(1)).onModel();
        Step.STEP((String)"Check the normal user can only view the child rule set.");
        RestRuleSetModelsCollection userViewOfRuleSets = this.privateAPIForUser().usingNode((RepoTestModel)childFolder).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)userViewOfRuleSets.assertThat().entriesListContains("id", childRuleSet.getId())).and().entriesListDoesNotContain("id", parentRuleSet.getId());
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetsAndOwningFolders() {
        Step.STEP((String)"Get the rule sets and owning folders");
        RestRuleSetModelsCollection ruleSets = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).include(new String[]{"owningFolder"})).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleSetModel)((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().assertThat().field("owningFolder").is((Object)this.ruleFolder.getNodeRef())).assertThat().field("id").is((Object)this.ruleSetId);
        ruleSets.assertThat().entriesListCountIs(1);
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetsAndOwnedInclusionType() {
        Step.STEP((String)"Get the rule sets and inclusion type");
        RestRuleSetModelsCollection ruleSets = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).include(new String[]{"inclusionType"})).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleSetModel)((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().assertThat().field("inclusionType").is((Object)"owned")).assertThat().field("id").is((Object)this.ruleSetId);
        ruleSets.assertThat().entriesListCountIs(1);
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetsAndInheritedInclusionType() {
        Step.STEP((String)"Get the rule sets and inclusion type");
        RestRuleSetModelsCollection ruleSets = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.inheritingChildFolder).include(new String[]{"inclusionType"})).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleSetModel)((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().assertThat().field("inclusionType").is((Object)"inherited")).assertThat().field("id").is((Object)this.ruleSetId);
        ruleSets.assertThat().entriesListCountIs(1);
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetsWithoutInheriting() {
        Step.STEP((String)"Get the rule sets and inclusion type");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.notInheritingChildFolder).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSets.assertThat().entriesListCountIs(0);
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getRuleSetById() {
        Step.STEP((String)"Get the rule set using its rule set id");
        RestRuleSetModel ruleSet = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).getRuleSet(this.ruleSetId);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleSetModel)((RestRuleSetModel)((RestRuleSetModel)((RestRuleSetModel)((RestRuleSetModel)ruleSet.assertThat().field("id").is((Object)this.ruleSetId)).assertThat().field("owningFolder").isNull()).assertThat().field("inheritedBy").isNull()).assertThat().field("linkedToBy").isNull()).assertThat().field("isInherited").isNull()).assertThat().field("isLinkedTo").isNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void getDefaultRuleSetById() {
        Step.STEP((String)"Get the default rule set for the folder");
        RestRuleSetModel ruleSet = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).getDefaultRuleSet();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSet.assertThat().field("id").isNotNull();
    }

    @Test(groups={"rest-api", "rules"})
    public void getDefaultRuleSetForNonExistentFolder() {
        Step.STEP((String)"Try to load a rule set for a non-existent folder.");
        FolderModel nonExistentFolder = FolderModel.getRandomFolderModel();
        nonExistentFolder.setNodeRef("fake-id");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)nonExistentFolder).getDefaultRuleSet();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetByNonExistingId() {
        Step.STEP((String)"Get the rule set using fake rule set id");
        String fakeRuleSetId = "fake-rule-set-id";
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).getRuleSet(fakeRuleSetId);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetAndOwningFolder() {
        Step.STEP((String)"Get the rule set and owning folder");
        RestRuleSetModel ruleSet = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.ruleFolder).include(new String[]{"owningFolder"})).getRuleSet(this.ruleSetId);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleSetModel)ruleSet.assertThat().field("owningFolder").is((Object)this.ruleFolder.getNodeRef())).assertThat().field("id").is((Object)this.ruleSetId);
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetAndInheritedBy() {
        Step.STEP((String)"Create a site owned by admin and add user as a contributor");
        SiteModel siteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.dataUser.addUserToSite(this.user, siteModel, UserRole.SiteContributor);
        Step.STEP((String)"Create the folder structure");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        FolderModel publicFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)folder)).createFolder();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)folder)).createFolder();
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)privateFolder)).setInheritPermissions(false);
        FolderModel publicGrandchild = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        this.coreAPIForAdmin().usingActions().executeAction("move", (RepoTestModel)publicGrandchild, (Map)ImmutableMap.of((Object)"destination-folder", (Object)("workspace://SpacesStore/" + privateFolder.getNodeRef())));
        FolderModel nonInheritingFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)folder)).createFolder();
        RestRuleSettingsModel nonInheriting = new RestRuleSettingsModel();
        nonInheriting.setKey("-isInheritanceEnabled-");
        nonInheriting.setValue((Object)false);
        this.privateAPIForUser().usingNode((RepoTestModel)nonInheritingFolder).usingIsInheritanceEnabledRuleSetting().updateSetting(nonInheriting);
        FolderModel linkingFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)nonInheritingFolder)).createFolder();
        FolderModel descendantFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)linkingFolder)).createFolder();
        Step.STEP((String)"Create an inheritable rule in the folder and get the rule set id.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithModifiedValues();
        this.privateAPIForUser().usingNode((RepoTestModel)folder).usingDefaultRuleSet().createSingleRule(ruleModel);
        RestRuleSetModelsCollection ruleSets = this.privateAPIForUser().usingNode((RepoTestModel)folder).getListOfRuleSets();
        String ruleSetId = ((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().getId();
        Step.STEP((String)"Create the link to the rule from the linking folder");
        RestRuleSetLinkModel ruleSetLink = new RestRuleSetLinkModel();
        ruleSetLink.setId(folder.getNodeRef());
        this.privateAPIForUser().usingNode((RepoTestModel)linkingFolder).createRuleLink(ruleSetLink);
        Step.STEP((String)"Remove the user from  the site");
        this.dataUser.removeUserFromSite(this.user, siteModel);
        Step.STEP((String)"Get the rule set and inheriting folders");
        RestRuleSetModel ruleSet = ((Node)this.privateAPIForUser().usingNode((RepoTestModel)folder).include(new String[]{"inheritedBy"})).getRuleSet(ruleSetId);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        List<String> expectedInheritors = List.of(publicFolder.getNodeRef(), descendantFolder.getNodeRef(), publicGrandchild.getNodeRef());
        ((RestRuleSetModel)ruleSet.assertThat().field("inheritedBy").is(expectedInheritors)).assertThat().field("id").is((Object)ruleSetId);
    }

    @Test(groups={"rest-api", "rules"})
    public void getRuleSetsAndLinkedToBy() {
        Step.STEP((String)"Create a site owned by admin and add user as a contributor");
        SiteModel siteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.dataUser.addUserToSite(this.user, siteModel, UserRole.SiteContributor);
        Step.STEP((String)"Create the folder structure");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        FolderModel publicFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(siteModel)).createFolder();
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)privateFolder)).setInheritPermissions(false);
        Step.STEP((String)"Remove the user from  the site");
        this.dataUser.removeUserFromSite(this.user, siteModel);
        Step.STEP((String)"Create a rule in the folder and link to it from the other two.");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        RestRuleSetModelsCollection ruleSets = this.privateAPIForAdmin().usingNode((RepoTestModel)ruleFolder).getListOfRuleSets();
        String ruleSetId = ((RestRuleSetModel)ruleSets.getEntries().get(0)).onModel().getId();
        RestRuleSetLinkModel ruleSetLink = new RestRuleSetLinkModel();
        ruleSetLink.setId(ruleFolder.getNodeRef());
        this.privateAPIForUser().usingNode((RepoTestModel)publicFolder).createRuleLink(ruleSetLink);
        this.privateAPIForAdmin().usingNode((RepoTestModel)privateFolder).createRuleLink(ruleSetLink);
        Step.STEP((String)"Get the rule set and linkedToBy field");
        RestRuleSetModel ruleSet = ((Node)this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).include(new String[]{"linkedToBy"})).getRuleSet(ruleSetId);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleSetModel)ruleSet.assertThat().field("linkedToBy").is(List.of(publicFolder.getNodeRef()))).assertThat().field("id").is((Object)ruleSetId);
    }

    @Test
    public void getRuleSetAndIsInheritedWithoutPermission() {
        Step.STEP((String)"Create a site owned by admin and add user as a contributor");
        SiteModel siteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.dataUser.addUserToSite(this.user, siteModel, UserRole.SiteContributor);
        Step.STEP((String)"Create a folder with a rule set and a private child folder to inherit it");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)ruleFolder)).createFolder();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Remove the user from  the site");
        this.dataUser.removeUserFromSite(this.user, siteModel);
        Step.STEP((String)"Get the rule set and isInherited field");
        RestRuleSetModel ruleSet = ((Node)this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).include(new String[]{"isInherited", "inheritedBy"})).getDefaultRuleSet();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleSetModel)ruleSet.assertThat().field("isInherited").is((Object)true)).assertThat().field("inheritedBy").isEmpty();
    }

    @Test
    public void getRuleSetAndIsInheritedViaLink() {
        Step.STEP((String)"Create a site and a folder with a rule");
        SiteModel siteModel = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Create a second folder in the site that links to the rule set");
        FolderModel secondFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)secondFolder)).createFolder();
        RestRuleSetLinkModel ruleSetLink = new RestRuleSetLinkModel();
        ruleSetLink.setId(ruleFolder.getNodeRef());
        this.privateAPIForUser().usingNode((RepoTestModel)secondFolder).createRuleLink(ruleSetLink);
        Step.STEP((String)"Get the rule set and isInherited field");
        RestRuleSetModel ruleSet = ((Node)this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).include(new String[]{"isInherited"})).getDefaultRuleSet();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSet.assertThat().field("isInherited").is((Object)true);
    }

    @Test
    public void getRuleSetAndIsInheritedCanBeFalse() {
        Step.STEP((String)"Create a site and a folder with a rule");
        SiteModel siteModel = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Create a second folder in the site that links to the rule set");
        FolderModel secondFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        RestRuleSetLinkModel ruleSetLink = new RestRuleSetLinkModel();
        ruleSetLink.setId(ruleFolder.getNodeRef());
        this.privateAPIForUser().usingNode((RepoTestModel)secondFolder).createRuleLink(ruleSetLink);
        Step.STEP((String)"Get the rule set and isInherited field");
        RestRuleSetModel ruleSet = ((Node)this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).include(new String[]{"isInherited"})).getDefaultRuleSet();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSet.assertThat().field("isInherited").is((Object)false);
    }

    @Test
    public void getRuleSetAndIsLinkedToWithoutPermission() {
        Step.STEP((String)"Create a site owned by admin and add user as a contributor");
        SiteModel siteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.dataUser.addUserToSite(this.user, siteModel, UserRole.SiteContributor);
        Step.STEP((String)"Create a folder with a rule set");
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Create a private folder linking to the rule set");
        FolderModel linkingFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(siteModel)).createFolder();
        RestRuleSetLinkModel linkModel = new RestRuleSetLinkModel();
        linkModel.setId(ruleFolder.getNodeRef());
        this.privateAPIForAdmin().usingNode((RepoTestModel)linkingFolder).createRuleLink(linkModel);
        Step.STEP((String)"Remove the user from  the site");
        this.dataUser.removeUserFromSite(this.user, siteModel);
        Step.STEP((String)"Get the rule set and isLinkedTo field");
        RestRuleSetModel ruleSet = ((Node)this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).include(new String[]{"isLinkedTo", "linkedToBy", "owningFolder"})).getDefaultRuleSet();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestRuleSetModel)ruleSet.assertThat().field("isLinkedTo").is((Object)true)).assertThat().field("linkedToBy").isEmpty();
    }

    @Test
    public void getRuleSetAndIsLinkedToCanBeFalse() {
        Step.STEP((String)"Create a site, a folder with a rule and a child folder that inherits it");
        SiteModel siteModel = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        FolderModel ruleFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(siteModel)).createFolder();
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)ruleFolder)).createFolder();
        Step.STEP((String)"Get the rule set and isLinkedTo field");
        RestRuleSetModel ruleSet = ((Node)this.privateAPIForUser().usingNode((RepoTestModel)ruleFolder).include(new String[]{"isLinkedTo"})).getDefaultRuleSet();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSet.assertThat().field("isLinkedTo").is((Object)false);
    }

    @Test(groups={"rest-api", "rules"})
    public void permissionsChecksForFolderWithPrivateAndPublicRuleSets() {
        Step.STEP((String)"Create a public site containing a parent and child folder with rule inheritance enabled.");
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        FolderModel parentFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(publicSite)).createFolder();
        FolderModel childFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)parentFolder)).createFolder();
        RestRuleSettingsModel enabled = new RestRuleSettingsModel();
        enabled.setValue((Object)true);
        this.privateAPIForUser().usingNode((RepoTestModel)parentFolder).usingRuleSetting("-isInheritanceEnabled-").updateSetting(enabled);
        Step.STEP((String)"Link the parent folder to a private rule set.");
        RestRuleSetLinkModel linkModel = new RestRuleSetLinkModel();
        linkModel.setId(this.privateFolder.getNodeRef());
        this.privateAPIForAdmin().usingNode((RepoTestModel)parentFolder).createRuleLink(linkModel);
        Step.STEP((String)"Create a rule on the child folder.");
        this.privateAPIForUser().usingNode((RepoTestModel)childFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        Step.STEP((String)"Use the admin user to get both rule sets.");
        RestRuleSetModelsCollection adminViewOfRuleSets = this.privateAPIForAdmin().usingNode((RepoTestModel)childFolder).getListOfRuleSets();
        RestRuleSetModel parentRuleSet = ((RestRuleSetModel)adminViewOfRuleSets.getEntries().get(0)).onModel();
        RestRuleSetModel childRuleSet = ((RestRuleSetModel)adminViewOfRuleSets.getEntries().get(1)).onModel();
        Step.STEP((String)"Check the normal user can only view the child rule set.");
        this.privateAPIForUser().usingNode((RepoTestModel)childFolder).getRuleSet(parentRuleSet.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.privateAPIForUser().usingNode((RepoTestModel)childFolder).getRuleSet(childRuleSet.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    private RestCoreAPI coreAPIForAdmin() {
        return this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI();
    }

    private RestPrivateAPI privateAPIForUser() {
        return this.restClient.authenticateUser(this.user).withPrivateAPI();
    }

    private RestPrivateAPI privateAPIForAdmin() {
        return this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI();
    }
}

