/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core;

import io.restassured.RestAssured;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.http.HttpMethod;

public class RestRequest {
    private static final String TOKEN_REGEX = "\\{.*?}";
    private String body;
    private HttpMethod httpMethod;
    private String path;
    private Object[] pathParams;
    private String contentType = "UTF-8";

    private RestRequest(HttpMethod httpMethod, String path, String ... pathParams) {
        this(httpMethod, "", path, pathParams);
    }

    private RestRequest(HttpMethod httpMethod, String body, String path, String ... pathParams) {
        this.setHttpMethod(httpMethod);
        this.setPath(path);
        this.setPathParams(pathParams);
        this.setBody(body);
        this.constructPath();
    }

    public static RestRequest simpleRequest(HttpMethod httpMethod, String path, String ... pathParams) {
        return new RestRequest(httpMethod, path, pathParams);
    }

    public static RestRequest requestWithBody(HttpMethod httpMethod, String body, String path, String ... pathParams) {
        return new RestRequest(httpMethod, body, path, pathParams);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.addQueryParamsIfNeeded();
    }

    public Object[] getPathParams() {
        return this.pathParams;
    }

    public void setPathParams(Object[] pathParams) {
        this.pathParams = pathParams;
        this.addQueryParamsIfNeeded();
    }

    private void addQueryParamsIfNeeded() {
        if (this.path == null || this.path.length() == 0 || this.pathParams == null) {
            return;
        }
        int groupCount = (int)Pattern.compile(TOKEN_REGEX).matcher(this.path).results().count();
        if (this.pathParams.length > groupCount) {
            String queryParams = IntStream.range(0, this.pathParams.length - groupCount).mapToObj(index -> "{parameter" + index + "}").collect(Collectors.joining("&"));
            this.path = this.path + (this.path.contains("?") ? "&" : "?") + queryParams;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("Request: ").append(this.getHttpMethod()).append(" ").append(RestAssured.baseURI).append(":").append(RestAssured.port).append("/").append(RestAssured.basePath).append("/");
        sb.append(this.constructPath());
        if (!this.getBody().isEmpty()) {
            sb.append("\nbody:").append(this.getBody());
        }
        sb.append("\n");
        return sb.toString();
    }

    private String constructPath() {
        String getPathFormatted = this.getPath();
        if (this.getPath().contains("{")) {
            getPathFormatted = this.getPath().replaceAll(TOKEN_REGEX, "%s");
            getPathFormatted = String.format(getPathFormatted, this.getPathParams());
        }
        return getPathFormatted;
    }
}

