/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'aforascu' on '2018-01-10 16:02' from 'Alfresco Content Services REST API' swagger file 
 * Generated from 'Alfresco Content Services REST API' swagger file
 * Base Path {@linkplain /alfresco/api}
 */
public class RestLicenseInfoModel extends TestModel implements IRestModel<RestLicenseInfoModel>
{
    @JsonProperty(value = "entry")
    RestLicenseInfoModel model;

    @Override
    public RestLicenseInfoModel onModel()
    {
        return model;
    }


    @JsonProperty(required = true)    
    private String issuedAt;	    

    @JsonProperty(required = true)    
    private String expiresAt;	    

    @JsonProperty(required = true)    
    private int remainingDays;	    

    @JsonProperty(required = true)    
    private String holder;	    

    @JsonProperty(required = true)    
    private String mode;	    

    private RestEntitlementsInfoModel entitlements;	    

    public String getIssuedAt()
    {
        return this.issuedAt;
    }

    public void setIssuedAt(String issuedAt)
    {
        this.issuedAt = issuedAt;
    }				

    public String getExpiresAt()
    {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt)
    {
        this.expiresAt = expiresAt;
    }				

    public int getRemainingDays()
    {
        return this.remainingDays;
    }

    public void setRemainingDays(int remainingDays)
    {
        this.remainingDays = remainingDays;
    }				

    public String getHolder()
    {
        return this.holder;
    }

    public void setHolder(String holder)
    {
        this.holder = holder;
    }				

    public String getMode()
    {
        return this.mode;
    }

    public void setMode(String mode)
    {
        this.mode = mode;
    }				

    public RestEntitlementsInfoModel getEntitlements()
    {
        return this.entitlements;
    }

    public void setEntitlements(RestEntitlementsInfoModel entitlements)
    {
        this.entitlements = entitlements;
    }				
}
 
