/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.containers;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteContainerModel;
import org.alfresco.rest.model.RestSiteContainerModelsCollection;
import org.alfresco.rest.requests.Site;
import org.alfresco.utility.constants.ContainerName;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteContainersTests
extends RestTest {
    private UserModel adminUserModel;
    private SiteModel publicSiteModel;
    private SiteModel publicSiteWithContainers;
    private SiteModel moderatedSiteModel;
    private SiteModel privateSiteModel;
    private DataUser.ListUserWithRoles publicSiteUsers;
    private DataUser.ListUserWithRoles publicSiteWithContainersUsers;
    private RestSiteContainerModelsCollection restSiteContainers;
    private int totalItems;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.publicSiteWithContainers = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.publicSiteUsers = this.dataUser.addUsersWithRolesToSite(this.publicSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.publicSiteWithContainersUsers = this.dataUser.addUsersWithRolesToSite(this.publicSiteWithContainers, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.publicSiteWithContainers)).createRandomLink();
        ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.moderatedSiteModel)).createRandomLink();
        ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.privateSiteModel)).createRandomLink();
        this.restSiteContainers = this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers();
        this.totalItems = this.restSiteContainers.getPagination().getTotalItems();
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role gets site containers and gets status code OK (200)")
    public void getSiteContainersWithManagerRole() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager));
        ((RestModels)((RestModels)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets site containers and gets status code OK (200)")
    public void getSiteContainersWithCollaboratorRole() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator));
        ((RestModels)((RestModels)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets site containers and gets status code OK (200)")
    public void getSiteContainersWithContributorRole() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteContributor));
        ((RestModels)((RestModels)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets site containers and gets status code OK (200)")
    public void getSiteContainersWithConsumerRole() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteConsumer));
        ((RestModels)((RestModels)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Admin user gets site containers information and gets status code OK (200)")
    public void getSiteContainersWithAdminUser() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        ((RestModels)((RestModels)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().assertThat().entriesListIsNotEmpty()).assertThat().paginationExist()).and().paginationField("count").isNot((Object)"0");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Failed authentication get site containers call returns status code 401 with Manager role")
    public void unauthenticatedUserIsNotAuthorizedToRetrieveSiteContainers() throws Exception {
        UserModel userModel = this.dataUser.createRandomTestUser();
        userModel.setPassword("user wrong password");
        this.dataUser.addUserToSite(userModel, this.publicSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(userModel).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site container request returns status code 200 with valid maxItems parameter")
    public void getContainersWithValidMaxItems() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"maxItems=5"}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(2)).and().entriesListContains("folderId", ContainerName.documentLibrary.toString())).and().entriesListContains("folderId", ContainerName.links.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.withParams(new String[]{"maxItems=1"}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(1);
        ((RestModels)this.restClient.withParams(new String[]{"maxItems=3"}).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().assertThat().entriesListCountIs(1)).and().entriesListContains("folderId", ContainerName.documentLibrary.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site container request returns status code 400 when invalid maxItems parameter is used")
    public void getContainersWithMaxItemsZero() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"maxItems=0"}).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Only positive values supported for maxItems");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site container request returns status code 400 when invalid maxItems parameter is used")
    public void getContainersWithMaxItemsCharacter() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"maxItems=test"}).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "test"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site container request returns status code 200 when maxItems parameter starts with multiple zero")
    public void getContainersWithMaxItemsMultipleZero() throws Exception {
        this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"maxItems=000007"}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(2);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site containers request returns status code 200 when valid skipCount parameter is used")
    public void getSiteContainersWithValidSkipCount() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"skipCount=1"}).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().assertThat().entriesListCountIs(0);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"skipCount=1"}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(1);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteConsumer)).withParams(new String[]{"skipCount=2"}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(0);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"skipCount=0"}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(2);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site containers request returns status code 400 when invalid skipCount parameter is used")
    public void getSiteContainersWithSkipCountCharacter() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"skipCount=abc"}).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "abc"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site containers request returns status code 200 when skipCount parameter starts with multiple zero")
    public void getSiteContainersWithSkipCountMultipleZero() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"skipCount=00002"}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(0);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site containers request returns status code 400 when site doesn't exist")
    public void getSiteContainersWithNonExistentSite() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingSite("NonExistentSiteId").getSiteContainers();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "NonExistentSiteId"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site containers request returns status 200 for private site")
    public void getSiteContainersForPrivateSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).getSiteContainers().assertThat().entriesListCountIs(2);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site containers request returns status 200 for moderated site")
    public void getSiteContainersForModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).getSiteContainers().assertThat().entriesListCountIs(2);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site containers request returns status 200 for several containers")
    public void getSiteContainersForSeveralItems() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(2)).and().entriesListContains("folderId", ContainerName.documentLibrary.toString())).and().entriesListContains("folderId", ContainerName.links.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site containers request returns status 200 for one container")
    public void getSiteContainersWithOneItem() throws Exception {
        ((RestModels)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).getSiteContainers().assertThat().entriesListCountIs(1)).and().entriesListContains("folderId", ContainerName.documentLibrary.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site container request with properties parameter applied returns status code 200")
    public void getSiteContainersUsingPropertiesParameter() throws Exception {
        ((RestModels)((RestModels)((RestModels)((Site)this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSiteWithContainers).usingParams(new String[]{"properties=folderId"})).getSiteContainers().assertThat().entriesListCountIs(2)).and().entriesListContains("folderId", ContainerName.documentLibrary.toString())).and().entriesListContains("folderId", ContainerName.links.toString())).and().entriesListDoesNotContain("id");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site container request for a container that is not empty returns status code 200")
    public void getSiteContainersThatIsNotEmpty() throws Exception {
        ((RestModels)this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(2)).and().entriesListContains("folderId", ContainerName.documentLibrary.toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site containers request returns status code 200 when first container is skipped")
    public void getSiteContainersAndSkipFirst() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"skipCount=1"}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(1)).and().entriesListDoesNotContain("folderId", ((RestSiteContainerModel)this.restSiteContainers.getEntries().get(0)).onModel().getFolderId())).and().entriesListContains("folderId", ((RestSiteContainerModel)this.restSiteContainers.getEntries().get(1)).onModel().getFolderId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site containers request and get last container returns status code 200")
    public void getLastSiteContainer() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"skipCount=" + String.valueOf(this.totalItems - 1)}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListCountIs(1)).and().entriesListDoesNotContain("folderId", ((RestSiteContainerModel)this.restSiteContainers.getEntries().get(0)).onModel().getFolderId())).and().entriesListContains("folderId", ((RestSiteContainerModel)this.restSiteContainers.getEntries().get(1)).onModel().getFolderId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site containers request returns status code 200 when high skipCount parameter is used")
    public void getSiteContainersWithHighSkipCount() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"skipCount=999999"}).withCoreAPI().usingSite(this.publicSiteWithContainers).getSiteContainers().assertThat().entriesListIsEmpty()).and().entriesListCountIs(0)).and().paginationField("skipCount").is("999999");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get site container request for an empty siteId returns status code 404")
    public void getSiteContainersForEmptySiteId() throws Exception {
        this.restClient.authenticateUser(this.publicSiteWithContainersUsers.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite("").getSiteContainers();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "")).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }
}

