/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.membershipRequests;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteMembershipRequestModel;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class UpdateSiteMembershipRequestTests
extends RestTest {
    private SiteModel moderatedSite;
    private DataUser.ListUserWithRoles usersWithRoles;
    private UserModel adminUser;
    private UserModel managerUser;
    private String updatedMessage;
    private String moderatedSiteId;
    private RestSiteMembershipRequestModel requestUpdateModel;
    private RestSiteMembershipRequestModel requestGetModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUser = this.dataUser.getAdminUser();
        this.managerUser = this.dataUser.createRandomTestUser();
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createModeratedRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.moderatedSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.updatedMessage = "Please review my request";
        this.moderatedSiteId = this.moderatedSite.getId();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify user is able to update its own site membership request")
    public void userIsAbleToUpdateItsOwnSiteMembershipRequest() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.requestUpdateModel = this.restClient.withCoreAPI().usingUser(newMember).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.requestUpdateModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("message").is((Object)this.updatedMessage)).assertThat().field("site").isNotEmpty()).assertThat().field("modifiedAt").isNotEmpty()).assertThat().field("createdAt").isNotEmpty();
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.requestUpdateModel.getSite().assertThat().field("visibility").is((Object)this.moderatedSite.getVisibility())).assertThat().field("guid").is((Object)this.moderatedSite.getGuid())).assertThat().field("description").is((Object)this.moderatedSite.getDescription())).assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("preset").is((Object)"site-dashboard")).assertThat().field("title").is((Object)this.moderatedSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is not able to update membership request of another user")
    public void siteManagerIsNotAbleToUpdateSiteMembershipRequestOfAnotherUser() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingUser(newMember).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is not able to update membership request of another user")
    public void siteCollaboratorIsNotAbleToUpdateSiteMembershipRequestOfAnotherUser() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(newMember).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is not able to update membership request of another user")
    public void siteContributorIsNotAbleToUpdateSiteMembershipRequestOfAnotherUser() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingUser(newMember).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is not able to update membership request of another user")
    public void siteConsumerIsNotAbleToUpdateSiteMembershipRequestOfAnotherUser() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(newMember).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify one user is not able to update membership request of another user")
    public void regularUserIsNotAbleToUpdateSiteMembershipRequestOfAnotherUser() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        UserModel otherMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(otherMember).withCoreAPI().usingUser(newMember).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to update membership request of another user")
    public void adminIsNotAbleToUpdateSiteMembershipRequestOfAnotherUser() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(newMember).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, newMember.getUsername()));
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify unauthorized user is not able to update user site membership request")
    public void unauthorizedUserIsNotAbleToUpdateSiteMembershipRequest() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        newMember.setPassword("fakePass");
        this.restClient.withCoreAPI().usingUser(newMember).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to update its own site membership request using -me-")
    public void usingMeUpdateSiteMembershipRequest() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.requestUpdateModel = this.restClient.withCoreAPI().usingMe().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)this.requestUpdateModel.assertMembershipRequestMessageIs(this.updatedMessage).and().field("id").is((Object)this.moderatedSite.getId())).and().field("modifiedAt").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user is not able to update its own site membership request")
    public void inexistentUserCannotUpdateSiteMembershipRequest() throws Exception {
        UserModel inexistentUser = UserModel.getRandomUserModel();
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingUser(inexistentUser).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, inexistentUser.getUsername()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to update its own site membership request for inexistent site")
    public void userCannotUpdateSiteMembershipRequestForInexistentSite() throws Exception {
        SiteModel randomSite = SiteModel.getRandomSiteModel();
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingMe().updateSiteMembershipRequest(randomSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, newMember.getUsername(), randomSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able not to update its own site membership request for public site")
    public void userCannotUpdateSiteMembershipRequestForPublicSite() throws Exception {
        SiteModel publicSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPublicRandomSite();
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(publicSite);
        this.restClient.withCoreAPI().usingMe().updateSiteMembershipRequest(publicSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, newMember.getUsername(), publicSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to update its own site membership request for private site")
    public void userCannotUpdateSiteMembershipRequestForPrivateSite() throws Exception {
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createPrivateRandomSite();
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(privateSite);
        this.restClient.withCoreAPI().usingMe().updateSiteMembershipRequest(privateSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, newMember.getUsername(), privateSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to update its own site membership request with initial message")
    public void userCanUpdateSiteMembershipRequestWithInitialMessage() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.updatedMessage, this.moderatedSite, "Accept me");
        this.requestUpdateModel = this.restClient.withCoreAPI().usingMe().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)this.requestUpdateModel.assertMembershipRequestMessageIs(this.updatedMessage).and().field("id").is((Object)this.moderatedSite.getId())).and().field("modifiedAt").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to update its own site membership request with different message")
    public void userCanUpdateSiteMembershipRequestWithDifferentMessage() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest("", this.moderatedSite, "Accept me");
        this.requestUpdateModel = this.restClient.withCoreAPI().usingMe().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)this.requestUpdateModel.assertMembershipRequestMessageIs(this.updatedMessage).and().field("id").is((Object)this.moderatedSite.getId())).and().field("modifiedAt").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify modifiedAt field for update siteMembership request call")
    public void verifyModifiedAtForUpdateSiteMembershipRequest() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        String firstModifiedAt = this.restClient.withCoreAPI().usingMe().updateSiteMembershipRequest(this.moderatedSite, "first message").getModifiedAt();
        String secondModifiedAt = this.restClient.withCoreAPI().usingMe().updateSiteMembershipRequest(this.moderatedSite, "second message").getModifiedAt();
        Assert.assertNotEquals((Object)firstModifiedAt, (Object)secondModifiedAt);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to update membership request of admin")
    public void userIsNotAbleToUpdateSiteMembershipRequestOfAdmin() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(newMember).withCoreAPI().usingUser(this.adminUser).updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format("The entity with id: " + RestErrorModel.ENTITY_NOT_FOUND, this.adminUser.getUsername())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager is able to update site membership request")
    public void updateSiteMembershipRequestAfterUserIsAddedAsMember() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        ((DataUser)this.dataUser.usingUser(this.managerUser)).addUserToSite(newMember, this.moderatedSite, UserRole.SiteManager);
        this.requestUpdateModel = this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.requestUpdateModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("message").is((Object)this.updatedMessage)).assertThat().field("modifiedAt").isNotEmpty()).assertThat().field("createdAt").isNotEmpty();
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.requestUpdateModel.getSite().assertThat().field("role").is((Object)UserRole.SiteManager)).assertThat().field("visibility").is((Object)this.moderatedSite.getVisibility())).assertThat().field("guid").is((Object)this.moderatedSite.getGuid())).assertThat().field("description").is((Object)this.moderatedSite.getDescription())).assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("preset").is((Object)"site-dashboard")).assertThat().field("title").is((Object)this.moderatedSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is able to update site membership request")
    public void adminIsAbleToUpdateHisSiteMembershipRequest() throws Exception {
        UserModel regularUser = this.dataUser.createRandomTestUser();
        SiteModel anotherModeratedSite = ((DataSite)this.dataSite.usingUser(regularUser)).createModeratedRandomSite();
        this.requestUpdateModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(anotherModeratedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.requestUpdateModel = this.restClient.withCoreAPI().usingAuthUser().updateSiteMembershipRequest(anotherModeratedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.requestUpdateModel.assertThat().field("id").is((Object)anotherModeratedSite.getId())).assertThat().field("message").is((Object)"Please review my request")).assertThat().field("modifiedAt").isNotEmpty()).assertThat().field("createdAt").isNotEmpty();
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.requestUpdateModel.getSite().assertThat().field("visibility").is((Object)anotherModeratedSite.getVisibility())).assertThat().field("guid").is((Object)anotherModeratedSite.getGuid())).assertThat().field("description").is((Object)anotherModeratedSite.getDescription())).assertThat().field("id").is((Object)anotherModeratedSite.getId())).assertThat().field("preset").is((Object)"site-dashboard")).assertThat().field("title").is((Object)anotherModeratedSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user update site membership request with no message then adds a new message")
    public void userUpdateSiteMembershipRequestWithNoMessageThenAddsNewMessage() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.requestUpdateModel = this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.requestUpdateModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("message").is((Object)"Please accept me");
        this.requestUpdateModel = this.restClient.withCoreAPI().usingMe().updateSiteMembershipRequest(this.moderatedSite, "");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.requestUpdateModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).and().field("modifiedAt").isNotEmpty()).assertThat().field("message").isNull();
        this.requestUpdateModel = this.restClient.withCoreAPI().usingMe().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.requestUpdateModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("message").is((Object)this.updatedMessage)).assertThat().field("modifiedAt").isNotEmpty()).assertThat().field("createdAt").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user updates site membership request and verifies 'ModifiedAt' field using GET")
    public void userUpdateSiteMembershipRequestAndCheckModifiedAtWithGet() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.requestUpdateModel = this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestSiteMembershipRequestModel)this.requestUpdateModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).assertThat().field("message").is((Object)"Please accept me");
        this.requestUpdateModel = this.restClient.withCoreAPI().usingAuthUser().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.requestGetModel = this.restClient.withCoreAPI().usingAuthUser().getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.requestGetModel.assertThat().field("id").is((Object)this.requestUpdateModel.getId())).and().field("modifiedAt").is((Object)this.requestUpdateModel.getModifiedAt())).assertThat().field("message").is((Object)this.requestUpdateModel.getMessage());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Update membership request - empty body")
    public void emptyBodyUpdateSiteMembershipRequest() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{\"\": \"\",\"\": \"\", \"\": \"\"}", (String)"people/{personId}/site-membership-requests/{siteId}", (String[])new String[]{this.adminUser.getUsername(), this.moderatedSite.getId()});
        this.restClient.processModel(RestSiteMembershipRequestModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"\""));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Update membership request -  missing 'Title' field from Json")
    public void missingTitleFieldBodyUpdateSiteMembershipRequest() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createModeratedRandomSite();
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(moderatedSite);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)("{\"message\":\"Please review my request\",\"id\":\"" + moderatedSite.getId() + "\"}"), (String)"people/{personId}/site-membership-requests/{siteId}", (String[])new String[]{newMember.getUsername(), moderatedSite.getId()});
        this.requestUpdateModel = (RestSiteMembershipRequestModel)this.restClient.processModel(RestSiteMembershipRequestModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.requestUpdateModel.assertThat().field("id").is((Object)moderatedSite.getId())).assertThat().field("message").is((Object)this.updatedMessage)).assertThat().field("site").isNotEmpty()).assertThat().field("modifiedAt").isNotEmpty()).assertThat().field("createdAt").isNotEmpty();
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.requestUpdateModel.getSite().assertThat().field("visibility").is((Object)moderatedSite.getVisibility())).assertThat().field("guid").is((Object)moderatedSite.getGuid())).assertThat().field("description").is((Object)moderatedSite.getDescription())).assertThat().field("id").is((Object)moderatedSite.getId())).assertThat().field("preset").is((Object)"site-dashboard")).assertThat().field("title").is((Object)moderatedSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Update site membership request - missing JSON body")
    public void missingJsonFieldBodyUpdateSiteMembershipRequest() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createModeratedRandomSite();
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(moderatedSite);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"", (String)"people/{personId}/site-membership-requests/{siteId}", (String[])new String[]{newMember.getUsername(), moderatedSite.getId()});
        this.requestUpdateModel = (RestSiteMembershipRequestModel)this.restClient.processModel(RestSiteMembershipRequestModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input")).containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Update site membership request - empty JSON body")
    public void emptyJsonFieldBodyUpdateSiteMembershipRequest() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createModeratedRandomSite();
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(moderatedSite);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)"{}", (String)"people/{personId}/site-membership-requests/{siteId}", (String[])new String[]{newMember.getUsername(), moderatedSite.getId()});
        this.requestUpdateModel = (RestSiteMembershipRequestModel)this.restClient.processModel(RestSiteMembershipRequestModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.requestUpdateModel.assertThat().field("id").is((Object)moderatedSite.getId())).assertThat().field("message").isNull()).assertThat().field("site").isNotEmpty()).assertThat().field("modifiedAt").isNotEmpty()).assertThat().field("createdAt").isNotEmpty();
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.requestUpdateModel.getSite().assertThat().field("visibility").is((Object)moderatedSite.getVisibility())).assertThat().field("guid").is((Object)moderatedSite.getGuid())).assertThat().field("description").is((Object)moderatedSite.getDescription())).assertThat().field("id").is((Object)moderatedSite.getId())).assertThat().field("preset").is((Object)"site-dashboard")).assertThat().field("title").is((Object)moderatedSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Update site membership request - invalid SiteId")
    public void invalidSiteIdUpdateSiteMembershipRequest() throws Exception {
        this.moderatedSite.setId("invalidSiteId");
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingAuthUser().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.managerUser.getUsername(), this.moderatedSite.getId()));
        this.moderatedSite.setId(this.moderatedSiteId);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Update site membership request - empty SiteId")
    public void emptySiteIdUpdateSiteMembershipRequest() throws Exception {
        this.moderatedSite.setId("");
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingAuthUser().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.PUT_EMPTY_ARGUMENT).containsErrorKey(RestErrorModel.PUT_EMPTY_ARGUMENT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
        this.moderatedSite.setId(this.moderatedSiteId);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user is not able to update site membership request")
    public void emptyUserCannotUpdateSiteMembershipRequest() throws Exception {
        UserModel emptyUser = new UserModel("", "password");
        this.restClient.authenticateUser(emptyUser).withCoreAPI().usingAuthUser().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Update site membership request - rejected Request")
    public void rejectRequestThenUpdateSiteMembershipRequest() throws Exception {
        UserModel userWithRejectedRequests = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userWithRejectedRequests).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(userWithRejectedRequests).withWorkflowAPI().getTasks().getTaskModelByDescription(this.moderatedSite);
        this.workflow.approveSiteMembershipRequest(this.managerUser.getUsername(), this.managerUser.getPassword(), taskModel.getId(), false, "Rejected");
        this.requestUpdateModel = this.restClient.authenticateUser(userWithRejectedRequests).withCoreAPI().usingMe().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, userWithRejectedRequests.getUsername(), this.moderatedSite.getId())).containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Update site membership request - approved Request")
    @Test(groups={"rest-api", "people", "regression"})
    public void approveRequestThenUpdateSiteMembershipRequest() throws Exception {
        UserModel userWithApprovedRequests = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userWithApprovedRequests).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(userWithApprovedRequests).withWorkflowAPI().getTasks().getTaskModelByDescription(this.moderatedSite);
        this.workflow.approveSiteMembershipRequest(this.managerUser.getUsername(), this.managerUser.getPassword(), taskModel.getId(), true, "Approve");
        this.requestUpdateModel = this.restClient.authenticateUser(userWithApprovedRequests).withCoreAPI().usingMe().updateSiteMembershipRequest(this.moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, userWithApprovedRequests.getUsername(), this.moderatedSite.getId())).containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Update site membership request using invalid network")
    public void updateSiteMembershipRequestUsingInvalidNetwork() throws Exception {
        UserModel invalidUserNetwork = this.dataUser.createRandomTestUser();
        SiteModel site = ((DataSite)this.dataSite.usingUser(invalidUserNetwork)).createModeratedRandomSite();
        ((DataSite)((DataSite)this.dataSite.usingUser(invalidUserNetwork)).usingSite(site)).addSiteToFavorites();
        invalidUserNetwork.setDomain("invalidNetwork");
        this.requestUpdateModel = this.restClient.authenticateUser(invalidUserNetwork).withCoreAPI().usingMe().updateSiteMembershipRequest(site, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to update a deleted site membership request")
    public void userCantUpdateSiteMembershipRequestForDeletedRequest() throws Exception {
        SiteModel moderatedSite = ((DataSite)this.dataSite.usingUser(this.managerUser)).createModeratedRandomSite();
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(moderatedSite);
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().deleteSiteMembershipRequest(moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.requestUpdateModel = this.restClient.withCoreAPI().usingAuthUser().updateSiteMembershipRequest(moderatedSite, this.updatedMessage);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, newMember.getUsername(), moderatedSite.getId()));
    }
}

