/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.exception.EmptyRestModelCollectionException;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteProcessItemFullTests
extends RestTest {
    private FileModel document;
    private FileModel document2;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private UserModel adminUser;
    private UserModel anotherUser;
    private ProcessModel processModel;
    private RestItemModelsCollection items;
    private RestItemModel processItem;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsProcess)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Add a new process item, update the item and then delete.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void createUpdateDeleteProcessItem() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.document2 = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.MSPOWERPOINT);
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.processItem.setName("newItemName");
        this.processItem.assertThat().field("name").is((Object)"newItemName");
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessItems().assertThat().entriesListDoesNotContain("name", this.processItem.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item using any user.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessItemByAnyUser() throws Exception {
        this.anotherUser = this.dataUser.createRandomTestUser();
        this.document2 = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.HTML);
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.anotherUser).withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(String.format(RestErrorModel.ACCESS_INFORMATION_NOT_ALLOWED, this.processModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).containsErrorKey(String.format(RestErrorModel.ACCESS_INFORMATION_NOT_ALLOWED, this.processModel.getId())).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item with admin.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessItemWithAdmin() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.document2 = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.HTML);
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessVariables().assertThat().entriesListDoesNotContain("name", this.processItem.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item by the user who is involved in the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessItemByUserInvolvedInTheProcess() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessVariables().assertThat().entriesListDoesNotContain("name", this.processItem.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item by the user who started the process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessItemByUserThatStartedTheProcess() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessVariables().assertThat().entriesListDoesNotContain("name", this.processItem.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item for a deleted process.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessItemsForDeletedProcess() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.processModel.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item by inexistent user.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessItemByInexistentUser() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.document);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(UserModel.getRandomUserModel()).withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(this.processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item for process without items.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"}, expectedExceptions={EmptyRestModelCollectionException.class})
    public void deleteProcessItemsForProcessWithoutItems() throws Exception {
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.items = this.restClient.withWorkflowAPI().usingProcess(this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.items.assertThat().entriesListIsEmpty();
        this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem((RestItemModel)this.items.getOneRandomEntry());
    }
}

