/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.general;

import java.util.UUID;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.requests.Node;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.TestModel;
import org.alfresco.utility.model.UserModel;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class ResourceCreator<RESOURCE extends TestModel, SELF extends Creator<RESOURCE, ?>>
implements Creator<RESOURCE, SELF> {
    protected UserModel user;
    protected String name;
    protected String alias;

    protected abstract SELF self();

    @Override
    public SELF withName(String name) {
        this.name = name;
        return this.self();
    }

    public SELF withAlias(String alias) {
        this.alias = alias;
        return this.self();
    }

    public SELF withRandomName() {
        return this.withName(this.generateRandomName());
    }

    public SELF withRandomName(String prefix) {
        return this.withName(this.generateRandomNameWith(prefix));
    }

    public SELF withRandomName(String prefix, String suffix) {
        return this.withName(this.generateRandomNameWith(prefix, suffix));
    }

    @Override
    public <USER extends UserModel> SELF asUser(USER user) {
        this.user = user;
        return this.self();
    }

    protected String generateRandomName() {
        return this.generateRandomNameWith(RandomStringUtils.randomAlphanumeric((int)5) + "_");
    }

    protected String generateRandomNameWith(String prefix) {
        return this.generateRandomNameWith(prefix, "");
    }

    protected String generateRandomNameWith(String prefix, String suffix) {
        return prefix + String.valueOf(UUID.randomUUID()) + suffix;
    }

    protected Node buildNodeRestRequest(RestWrapper restClient, RepoTestModel node) {
        return restClient.authenticateUser(this.user).withCoreAPI().usingNode(node);
    }
}

